/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.common.net;

import com.buabook.common.connection.Process;
import com.buabook.common.net.exceptions.FailedToBindToPortException;
import com.buabook.common.net.interfaces.INewClientSocketListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketAcceptorThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(SocketAcceptorThread.class);
    private final Process bindToPort;
    private final ServerSocket serverSocket;
    private final List<INewClientSocketListener> newConnectionListeners;

    public SocketAcceptorThread(Process bindToPort) throws IllegalArgumentException, FailedToBindToPortException {
        if (bindToPort == null || bindToPort.getPort() == null || bindToPort.getPort() <= 0) {
            throw new IllegalArgumentException("Invalid port specified [ Port: " + bindToPort + " ]");
        }
        this.bindToPort = bindToPort;
        this.serverSocket = SocketAcceptorThread.openServerSocket(bindToPort);
        this.newConnectionListeners = new CopyOnWriteArrayList<INewClientSocketListener>();
        this.setName("SocketAcceptor-" + bindToPort.toString());
    }

    @Override
    public void run() {
        while (!this.serverSocket.isClosed()) {
            this.waitForClient();
        }
        log.error("Server socket at {} has been closed. This thread will now terminate.", (Object)this.bindToPort.toString());
    }

    public void addNewConnectionListener(INewClientSocketListener listener) {
        if (listener == null) {
            return;
        }
        if (this.newConnectionListeners.contains(listener)) {
            return;
        }
        this.newConnectionListeners.add(listener);
    }

    public void removeConnectionListener(INewClientSocketListener listener) {
        if (listener == null) {
            return;
        }
        if (this.newConnectionListeners.contains(listener)) {
            return;
        }
        this.newConnectionListeners.remove(listener);
    }

    private void waitForClient() {
        Socket socket = null;
        log.info("Waiting for client connection on socket {}", (Object)this.serverSocket.getLocalSocketAddress());
        try {
            socket = this.serverSocket.accept();
        }
        catch (IOException e) {
            log.error("Failed to accept new incoming client connection [ Server Socket: {} ]. Error - {}", (Object)this.serverSocket.getLocalSocketAddress(), (Object)e.getMessage());
            return;
        }
        for (INewClientSocketListener listener : this.newConnectionListeners) {
            listener.notifyNewClientSocket(socket);
        }
    }

    public static ServerSocket openServerSocket(Process bindToPort) throws FailedToBindToPortException {
        ServerSocket newServerSocket = null;
        log.info("Attempting to bind to port {}", (Object)bindToPort);
        try {
            newServerSocket = new ServerSocket(bindToPort.getPort());
        }
        catch (IOException | SecurityException e) {
            log.error("Failed to bind to port {}. Error - {}", (Object)bindToPort, (Object)e.getMessage());
            throw new FailedToBindToPortException(e);
        }
        log.info("Successfully bound to port {}", (Object)bindToPort);
        return newServerSocket;
    }
}

