/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.common.random;

import com.google.common.math.IntMath;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RandomCodeGenerator {
    private static final int TO_STRING_RADIX = 36;
    private final SecureRandom random = new SecureRandom();

    public String generateCode(int requiredCodeLength) throws IllegalArgumentException {
        if (requiredCodeLength <= 0) {
            throw new IllegalArgumentException("Required code length must be positive");
        }
        int randomBitLength = IntMath.checkedPow((int)requiredCodeLength, (int)2);
        String newReferralCode = new BigInteger(randomBitLength, this.random).toString(36);
        if (newReferralCode.length() > requiredCodeLength) {
            return newReferralCode.substring(0, requiredCodeLength);
        }
        if (newReferralCode.length() < requiredCodeLength) {
            return this.generateCode(requiredCodeLength);
        }
        return newReferralCode;
    }
}

