/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.common.shutdown;

import com.buabook.common.Formatters;
import com.buabook.common.shutdown.ShutdownFunction;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ShutdownThread.class);
    private final String applicationName;
    private final List<ShutdownFunction> shutdownFunctions;

    public ShutdownThread(String applicationName) {
        this(applicationName, new ArrayList<ShutdownFunction>());
    }

    public ShutdownThread(String applicationName, List<ShutdownFunction> shutdownFunctions) throws IllegalArgumentException {
        if (shutdownFunctions == null || Strings.isNullOrEmpty((String)applicationName)) {
            throw new IllegalArgumentException("Application name / shutdown function list");
        }
        this.applicationName = applicationName;
        this.shutdownFunctions = shutdownFunctions;
        this.setName("Shutdown-Thread");
        this.setPriority(1);
        this.setDaemon(true);
    }

    public ShutdownThread addShutdownFunction(ShutdownFunction function) throws IllegalArgumentException, IllegalStateException {
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        if (this.getState() != Thread.State.NEW) {
            throw new IllegalStateException();
        }
        this.shutdownFunctions.add(function);
        return this;
    }

    @Override
    public void run() {
        log.error("APPLICATION SHUTDOWN SIGNALLED");
        if (this.shutdownFunctions.size() > 0) {
            log.error("Running shutdown functions [ Function Count: " + this.shutdownFunctions.size() + " ]");
            this.shutdownFunctions.forEach(ShutdownFunction::doShutdown);
        }
        String exitStr = "*** " + this.applicationName.toUpperCase() + " IS EXITING @ " + DateTime.now().toString(Formatters.DATE_TIME_LOG) + " ***";
        log.error(exitStr);
        System.err.println(exitStr);
    }

    public static void addShutdownListener(ShutdownThread thread) {
        Runtime.getRuntime().addShutdownHook(thread);
    }
}

