/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.kx.c;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class Types {
    private static final List<Class<?>> ARRAY_PRIMITIVE_TYPES_LIST = ImmutableList.builder().add(int[].class).add(float[].class).add(double[].class).add(boolean[].class).add(byte[].class).add(short[].class).add(long[].class).add(char[].class).build();
    private static final Map<Class<?>, Object> KDB_NULL_TYPES = ImmutableMap.builder().put(Boolean.class, c.NULL('b')).put(UUID.class, c.NULL('g')).put(Byte.class, c.NULL('x')).put(Short.class, c.NULL('h')).put(Integer.class, c.NULL('i')).put(Long.class, c.NULL('j')).put(Float.class, c.NULL('e')).put(Double.class, c.NULL('f')).put(Character.class, c.NULL('c')).put(String.class, c.NULL('s')).put(Timestamp.class, c.NULL('p')).put(c.Month.class, c.NULL('m')).put(Date.class, c.NULL('d')).put(java.util.Date.class, c.NULL('z')).put(c.Timespan.class, c.NULL('n')).put(c.Minute.class, c.NULL('u')).put(c.Second.class, c.NULL('v')).put(Time.class, c.NULL('t')).put(char[].class, (Object)new char[0]).build();

    public static List<Class<?>> getArrayPrimitiveTypes() {
        return ARRAY_PRIMITIVE_TYPES_LIST;
    }

    public static Object getKdbNullFor(Class<?> javaType) {
        return KDB_NULL_TYPES.get(javaType);
    }
}

