/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.connection;

import com.buabook.kdb.connection.KdbProcess;
import com.buabook.kdb.exceptions.KdbTargetProcessUnavailableException;
import com.kx.c;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdbConnection
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KdbConnection.class);
    private static final Integer DEFAULT_RECONNECT_INTERVAL_MS = 2000;
    protected final Integer reconnectIntervalMs;
    private final KdbProcess process;
    private c connection;

    public KdbConnection(KdbProcess process) {
        this(process, DEFAULT_RECONNECT_INTERVAL_MS);
    }

    public KdbConnection(KdbProcess process, Integer reconnectIntervalMs) {
        this.process = process;
        this.reconnectIntervalMs = reconnectIntervalMs;
    }

    public void connect() throws KdbTargetProcessUnavailableException {
        if (this.process == null) {
            throw new KdbTargetProcessUnavailableException(new NullPointerException("The process specified is null!"));
        }
        if (this.isConnected()) {
            return;
        }
        log.info("Attempting to connect to: {}", (Object)this.process.toString());
        try {
            this.connection = new c(this.process.getHostname(), this.process.getPort(), this.process.getUserAndPassword());
        }
        catch (c.KException | IOException e) {
            this.connection = null;
            log.error("Failed to connect to '{}'. Error - {}", (Object)this.process, (Object)e.getMessage());
            throw new KdbTargetProcessUnavailableException("Target: " + (Object)((Object)this.process), e);
        }
        log.info("Successfully connected to: {}", (Object)this.process.toString());
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (IOException e) {
            log.debug("Failed to disconnect from the KDB process. Will null socket manually. Error - {}", (Object)e.getMessage());
        }
        this.connection = null;
        log.info("Disconnected from KDB process: {}", (Object)this.process);
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.s != null;
    }

    public c getConnection() {
        return this.connection;
    }

    public KdbProcess getRemoteProcess() {
        return this.process;
    }

    public void reconnect() {
        this.disconnect();
        while (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (KdbTargetProcessUnavailableException e) {
                log.warn("KDB process is still unavailable. Waiting {} ms... [ Process: {} ]", (Object)this.reconnectIntervalMs, (Object)this.process);
                try {
                    Thread.sleep(this.reconnectIntervalMs.intValue());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        log.info("Successfully reconnected to KDB process [ Process: {} ]", (Object)this.process);
    }

    @Override
    public void close() {
        this.disconnect();
    }
}

