/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.connection;

import com.buabook.common.connection.Process;
import com.google.common.base.Strings;

public class KdbProcess
extends Process {
    private final String username;
    private final String password;

    public KdbProcess(String hostname, Integer port) {
        this(hostname, port, null, null);
    }

    public KdbProcess(String hostname, String portStr) throws NumberFormatException {
        this(hostname, portStr, null, null);
    }

    public KdbProcess(String hostname, Integer port, String username, String password) {
        super(hostname, port);
        this.username = username;
        this.password = password;
    }

    public KdbProcess(String hostname, String portStr, String username, String password) throws NumberFormatException {
        super(hostname, portStr);
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        String userAndPass = this.getUserAndPassword();
        return "(kdb) " + super.toString() + (Strings.isNullOrEmpty((String)userAndPass) ? "" : " (User/Pass: " + userAndPass + ")");
    }

    public String getUserAndPassword() {
        if (Strings.isNullOrEmpty((String)this.getUsername())) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)this.getPassword())) {
            return this.getUsername();
        }
        return this.getUsername() + ":" + this.getPassword();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KdbProcess)) {
            return false;
        }
        boolean superEquals = super.equals(obj);
        KdbProcess kObj = (KdbProcess)((Object)obj);
        return superEquals && (this.username == null ? kObj.username == null : this.username.equals(kObj.username)) && (this.password == null ? kObj.password == null : this.password.equals(kObj.password));
    }

    public int hashCode() {
        return super.hashCode() + (this.username == null ? 0 : this.username.hashCode()) + (this.password == null ? 0 : this.password.hashCode());
    }
}

