/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.consumer;

import com.buabook.kdb.connection.KdbProcess;
import com.buabook.kdb.consumer.KdbConsumer;
import com.buabook.kdb.data.KdbDict;
import com.buabook.kdb.exceptions.KdbProcessSubscriptionFailedException;
import com.buabook.kdb.exceptions.KdbTargetProcessUnavailableException;
import com.buabook.kdb.interfaces.IKdbConsumerFailedListener;
import com.buabook.kdb.interfaces.IKdbRawDataConsumer;
import com.buabook.kdb.interfaces.IKdbTableConsumer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdbConsumerThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(KdbConsumerThread.class);
    private KdbConsumer consumer;
    private IKdbConsumerFailedListener failureListener;

    public KdbConsumerThread(KdbProcess server, List<String> tables, IKdbRawDataConsumer rawDataConsumer, IKdbTableConsumer tableConsumer, IKdbConsumerFailedListener failureListener) throws KdbTargetProcessUnavailableException {
        this.failureListener = failureListener;
        try {
            this.consumer = new KdbConsumer(server, tables, rawDataConsumer, tableConsumer);
        }
        catch (KdbTargetProcessUnavailableException e) {
            if (failureListener != null) {
                failureListener.notifyFailure(IKdbConsumerFailedListener.EFailureReason.CONNECTION_FAILED, e);
            }
            throw e;
        }
        this.setName("KdbConsumer-" + server.getHostname() + ":" + server.getPort());
        this.start();
    }

    public KdbConsumerThread(KdbProcess server, KdbDict subscriptionConfig, IKdbRawDataConsumer rawDataConsumer, IKdbTableConsumer tableConsumer, IKdbConsumerFailedListener failureListener) throws KdbTargetProcessUnavailableException {
        this.failureListener = failureListener;
        try {
            this.consumer = new KdbConsumer(server, subscriptionConfig, rawDataConsumer, tableConsumer);
        }
        catch (KdbTargetProcessUnavailableException e) {
            if (failureListener != null) {
                failureListener.notifyFailure(IKdbConsumerFailedListener.EFailureReason.CONNECTION_FAILED, e);
            }
            throw e;
        }
        this.setName("KdbConsumer-" + server.getHostname() + ":" + server.getPort());
        this.start();
    }

    @Override
    public void run() {
        block2: {
            try {
                this.consumer.subscribeAndListen();
            }
            catch (KdbProcessSubscriptionFailedException e) {
                log.error("The consumer failed to connect and subscribe to the kdb process. This thread will now die. Error - {}", (Object)e.getMessage());
                if (this.failureListener == null) break block2;
                this.failureListener.notifyFailure(IKdbConsumerFailedListener.EFailureReason.SUBSCRIPTION_FAILED, e);
            }
        }
    }
}

