/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.data;

import com.buabook.kdb.Converters;
import com.buabook.kdb.Types;
import com.buabook.kdb.data.PrintableDict;
import com.buabook.kdb.exceptions.DataOverwriteNotPermittedException;
import com.buabook.kdb.exceptions.DictUnionNotPermittedException;
import com.google.common.collect.Lists;
import com.kx.c;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdbDict {
    private static final Logger log = LoggerFactory.getLogger(KdbDict.class);
    private final Map<Object, Object> data = new HashMap<Object, Object>();

    public KdbDict() {
    }

    public KdbDict(c.Dict kdbDict) {
        this();
        this.setInitialDataSet(kdbDict);
    }

    public void setInitialDataSet(c.Dict kdbDict) throws DataOverwriteNotPermittedException, UnsupportedOperationException {
        Object[] values;
        if (!this.isEmpty().booleanValue()) {
            throw new DataOverwriteNotPermittedException();
        }
        if (!(kdbDict.x instanceof Object[]) && !Types.getArrayPrimitiveTypes().contains(kdbDict.x.getClass())) {
            throw new UnsupportedOperationException("Dictionary keys must be either an Object or primitive array");
        }
        if (!(kdbDict.y instanceof Object[]) && !Types.getArrayPrimitiveTypes().contains(kdbDict.y.getClass())) {
            throw new UnsupportedOperationException("Dictionary values must be either an Object or primitive array");
        }
        Object[] keys = Converters.arrayToObjectArray(kdbDict.x);
        if (keys.length != (values = Converters.arrayToObjectArray(kdbDict.y)).length) {
            throw new UnsupportedOperationException("Dictionary keys / values lengths mismatch");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.data.put(keys[i], values[i]);
        }
        log.trace("Received kdb dictionary: {}", this.data);
    }

    public KdbDict add(Object key, Object value) throws IllegalArgumentException, DataOverwriteNotPermittedException {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (this.data.containsKey(key)) {
            throw new DataOverwriteNotPermittedException("Key '" + key + "' already exists");
        }
        if (value == null) {
            throw new IllegalArgumentException("Java 'null' cannot be added to a kdb dictionary");
        }
        if (value instanceof List) {
            value = ((List)value).toArray();
        }
        this.data.put(key, value);
        return this;
    }

    public KdbDict add(Object key, Object value, Class<?> elementType) throws DataOverwriteNotPermittedException {
        if (value == null) {
            value = Types.getKdbNullFor(elementType);
        }
        return this.add(key, value);
    }

    public Object get(Object key) {
        return this.data.get(key);
    }

    public <T> T getAs(Object key, Class<T> returnType) throws ClassCastException {
        return returnType.cast(this.get(key));
    }

    public List<Object> getKeys() {
        return Lists.newArrayList(this.data.keySet());
    }

    public List<String> getKeysAsString() {
        return this.data.keySet().stream().map(Objects::toString).collect(Collectors.toList());
    }

    public Map<Object, Object> getDataStore() {
        return this.data;
    }

    public Map<String, Object> getDataStoreWithStringKeys() {
        return this.data.entrySet().stream().collect(Collectors.toMap(e -> Objects.toString(e.getKey()), Map.Entry::getValue));
    }

    public KdbDict union(KdbDict that) throws DictUnionNotPermittedException {
        if (that == null) {
            return this;
        }
        if (!Collections.disjoint(that.getKeys(), this.getKeys())) {
            throw new DictUnionNotPermittedException("The 2 rows contain one or more of the same element. Cannot union together.");
        }
        this.data.putAll(that.data);
        return this;
    }

    public c.Dict convertToDict() {
        Object[] keys = this.data.keySet().toArray();
        Object[] values = this.data.values().toArray();
        return new PrintableDict(keys, values);
    }

    public Boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Boolean has(Object key) {
        return this.data.containsKey(key);
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KdbDict)) {
            return false;
        }
        return this.data.equals(((KdbDict)obj).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public static KdbDict fromObject(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        return new KdbDict((c.Dict)object);
    }
}

