/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.data;

import com.buabook.kdb.Converters;
import com.buabook.kdb.data.KdbDict;
import com.buabook.kdb.data.KdbTableIterator;
import com.buabook.kdb.exceptions.DataOverwriteNotPermittedException;
import com.buabook.kdb.exceptions.TableColumnAlreadyExistsException;
import com.buabook.kdb.exceptions.TableSchemaMismatchException;
import com.google.common.base.Strings;
import com.kx.c;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdbTable
implements Iterable<KdbDict> {
    private static final Logger log = LoggerFactory.getLogger(KdbTable.class);
    private String tableName;
    private final Map<String, List<Object>> data;
    private Integer rowCount;

    public KdbTable(String tableName) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)tableName)) {
            throw new IllegalArgumentException();
        }
        this.tableName = tableName;
        this.data = new HashMap<String, List<Object>>();
        this.rowCount = 0;
    }

    public KdbTable(String tableName, c.Flip initialData) throws DataOverwriteNotPermittedException {
        this(tableName);
        this.setInitialDataSet(initialData);
    }

    public void setInitialDataSet(c.Flip initialData) throws DataOverwriteNotPermittedException {
        this.doSetOfInitialDataSet(initialData, false);
    }

    public void forceSetInitialDataSet(c.Flip initialData) {
        this.doSetOfInitialDataSet(initialData, true);
    }

    private void doSetOfInitialDataSet(c.Flip initialData, boolean overwrite) throws DataOverwriteNotPermittedException {
        if (!this.isEmpty().booleanValue() && !overwrite) {
            log.error("Data already exists and overwrite not set [ Table: {} ]", (Object)this.tableName);
            throw new DataOverwriteNotPermittedException();
        }
        this.data.clear();
        for (int cCount = 0; cCount < initialData.x.length; ++cCount) {
            String colName = initialData.x[cCount];
            Object[] colData = Converters.arrayToObjectArray(initialData.y[cCount]);
            ArrayList<Object> objArray = new ArrayList<Object>(Arrays.asList(colData));
            this.data.put(colName, objArray);
        }
        this.rowCount = Converters.arrayToObjectArray(initialData.y[0]).length;
    }

    public void addColumn(String columnName, List<Object> columnData) throws TableColumnAlreadyExistsException, TableSchemaMismatchException {
        if (this.data.containsKey(columnName)) {
            throw new TableColumnAlreadyExistsException("[ Column: " + columnName + " ]");
        }
        if (columnData.size() != this.rowCount.intValue()) {
            throw new TableSchemaMismatchException("Column length (" + columnData.size() + ") does not match the current number of rows (" + this.rowCount + ")!");
        }
        this.data.put(columnName, columnData);
    }

    public void deleteColumn(String columnName) {
        if (Strings.isNullOrEmpty((String)columnName)) {
            throw new IllegalArgumentException("No column name specified to delete");
        }
        this.data.remove(columnName);
    }

    public void addRow(KdbDict row) throws TableSchemaMismatchException {
        if (row == null) {
            return;
        }
        this.addRow(row.getDataStoreWithStringKeys());
    }

    public void addRow(Map<String, Object> row) throws TableSchemaMismatchException {
        if (row == null || row.isEmpty()) {
            return;
        }
        if (!this.isEmpty().booleanValue() && !row.keySet().containsAll(this.data.keySet())) {
            throw new TableSchemaMismatchException("Missing columns in row to add");
        }
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            Object rowValue;
            if (!this.data.containsKey(entry.getKey())) {
                this.data.put(entry.getKey(), new ArrayList());
            }
            if ((rowValue = entry.getValue()) instanceof List) {
                rowValue = ((List)rowValue).toArray();
            } else if (rowValue instanceof Enum) {
                rowValue = ((Enum)rowValue).toString();
            }
            this.data.get(entry.getKey()).add(rowValue);
        }
        KdbTable kdbTable = this;
        Integer n = kdbTable.rowCount;
        Integer n2 = kdbTable.rowCount = Integer.valueOf(kdbTable.rowCount + 1);
    }

    public void append(KdbTable that) throws TableSchemaMismatchException {
        if (that == null || that.isEmpty().booleanValue()) {
            return;
        }
        if (!this.tableName.equals(that.tableName)) {
            throw new TableSchemaMismatchException("Table names are different");
        }
        if (!this.isEmpty().booleanValue() && !that.getTableData().keySet().containsAll(this.data.keySet())) {
            throw new TableSchemaMismatchException("Tables have different schemas");
        }
        for (Map.Entry<String, List<Object>> column : that.getTableData().entrySet()) {
            if (!this.data.containsKey(column.getKey())) {
                this.data.put(column.getKey(), new ArrayList());
            }
            this.data.get(column.getKey()).addAll((Collection<Object>)column.getValue());
        }
        KdbTable kdbTable = this;
        kdbTable.rowCount = kdbTable.rowCount + that.getRowCount();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, List<Object>> getTableData() {
        return this.data;
    }

    public c.Flip convertToFlip() {
        if (this.isEmpty().booleanValue()) {
            return null;
        }
        TreeSet<String> orderedCols = new TreeSet<String>(this.data.keySet());
        String[] colNames = orderedCols.toArray(new String[0]);
        Object[] cols = new Object[this.data.keySet().size()];
        log.trace("Generating kdb Flip object [ Table: {} ] [ Row Count: {} ] [ Columns: {} ]", new Object[]{this.tableName, this.rowCount, orderedCols});
        for (int kCount = 0; kCount < colNames.length; ++kCount) {
            cols[kCount] = this.data.get(colNames[kCount]).toArray();
        }
        return new c.Flip(new c.Dict(colNames, cols));
    }

    public Integer getRowCount() {
        return this.rowCount;
    }

    public Boolean isEmpty() {
        return this.rowCount == 0 || this.data.isEmpty();
    }

    public void changeTableName(String newTableName) throws UnsupportedOperationException {
        if (Strings.isNullOrEmpty((String)newTableName)) {
            throw new UnsupportedOperationException("Table name cannot be null or empty");
        }
        this.tableName = newTableName;
    }

    public KdbDict getRow(int rowNumber) throws ArrayIndexOutOfBoundsException {
        if (rowNumber < 0 || rowNumber >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(rowNumber);
        }
        KdbDict row = new KdbDict();
        TreeSet<String> orderedCols = new TreeSet<String>(this.data.keySet());
        for (String column : orderedCols) {
            Object cell = this.data.get(column).get(rowNumber);
            row.add(column, cell, cell.getClass());
        }
        return row;
    }

    public static KdbTable buildFromRowList(String name, List<KdbDict> rows) throws TableSchemaMismatchException {
        KdbTable table = new KdbTable(name);
        rows.forEach(table::addRow);
        return table;
    }

    public static KdbTable fromObject(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        return new KdbTable("table", (c.Flip)object);
    }

    @Override
    public Iterator<KdbDict> iterator() {
        return new KdbTableIterator(this);
    }

    public Stream<KdbDict> stream() {
        Iterable iterable = () -> this.iterator();
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

