/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.publisher;

import com.buabook.kdb.Flips;
import com.buabook.kdb.connection.KdbConnection;
import com.buabook.kdb.connection.KdbProcess;
import com.buabook.kdb.data.KdbTable;
import com.buabook.kdb.exceptions.KdbTargetProcessUnavailableException;
import com.google.common.base.Strings;
import com.kx.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdbPublisher
extends KdbConnection {
    private static final Logger log = LoggerFactory.getLogger(KdbPublisher.class);
    private static final Duration DEFAULT_RESET_CONNECTION_DURATION = Duration.standardMinutes((long)30L);
    private static final String PUBLISH_FUNCTION = ".u.upd";
    private final Duration resetConnectionDuration;
    private DateTime lastPublishTime;

    public KdbPublisher(KdbProcess server) throws KdbTargetProcessUnavailableException {
        this(server, (Duration)null);
    }

    public KdbPublisher(KdbProcess server, Duration resetConnectionDuration) throws KdbTargetProcessUnavailableException {
        super(server);
        this.connect();
        this.resetConnectionDuration = resetConnectionDuration == null ? DEFAULT_RESET_CONNECTION_DURATION : resetConnectionDuration;
        this.lastPublishTime = DateTime.now();
        log.info("Successfully connected to kdb process for publishing [ Target: {} ] [ Connection Reset After: {} ]", (Object)server, (Object)resetConnectionDuration);
    }

    public List<Boolean> publish(List<KdbTable> tables) {
        if (tables == null || tables.size() == 0) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (KdbTable t : tables) {
            results.add(this.publish(t));
        }
        return results;
    }

    public Boolean publish(KdbTable table) {
        if (table == null) {
            return false;
        }
        return this.publish(table.getTableName(), table.convertToFlip());
    }

    public Boolean publish(String tableName, c.Flip tableData) {
        if (Strings.isNullOrEmpty((String)tableName) || tableData == null) {
            return true;
        }
        if (this.lastPublishTime.plus((ReadableDuration)this.resetConnectionDuration).isBeforeNow()) {
            log.info("Maximum connection duration has elapsed. Resetting connection before publishing");
            this.reconnect();
        }
        if (!this.isConnected()) {
            log.warn("Connection to kdb process lost! Attempting reconnect now...");
            this.reconnect();
        }
        log.debug("Publishing table update [ Table Name: {} ] [ Table Size: {} ]", (Object)tableName, (Object)Flips.getRowCount(tableData));
        try {
            this.getConnection().ks(PUBLISH_FUNCTION, tableName, tableData);
        }
        catch (RuntimeException e) {
            log.error("Uncaught RuntimeException during publishing. Error - {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        catch (IOException e) {
            log.error("Basic I/O exception occurred. Assuming connection has been corrupted. Attempting reconnect. Error - {}", (Object)e.getMessage());
            this.reconnect();
            return false;
        }
        this.lastPublishTime = DateTime.now();
        return true;
    }
}

