/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.publisher;

import com.buabook.kdb.connection.KdbProcess;
import com.buabook.kdb.data.KdbTable;
import com.buabook.kdb.exceptions.KdbPublisherAlreadyExistsException;
import com.buabook.kdb.exceptions.KdbPublisherDoesNotExistException;
import com.buabook.kdb.exceptions.KdbTargetProcessUnavailableException;
import com.buabook.kdb.publisher.KdbPublisherThread;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdbPublisherManager {
    private static final Logger log = LoggerFactory.getLogger(KdbPublisherManager.class);
    private final ConcurrentHashMap<KdbProcess, KdbPublisherThread> publishers = new ConcurrentHashMap();

    public void addPublisher(KdbProcess server) throws KdbTargetProcessUnavailableException, KdbPublisherAlreadyExistsException {
        if (this.publishers.containsKey((Object)server)) {
            log.error("This manager already contains a publisher to this KDB process! [ Process: {} ]", (Object)server);
            throw new KdbPublisherAlreadyExistsException(server.toString());
        }
        this.publishers.put(server, new KdbPublisherThread(server));
    }

    public void publish(List<KdbTable> tables) {
        this.publishers.forEach((process, publisher) -> publisher.publish(tables));
    }

    public void publish(List<KdbProcess> servers, List<KdbTable> tables) throws KdbPublisherDoesNotExistException {
        if (!((ConcurrentHashMap.CollectionView)((Object)this.publishers.keySet())).containsAll(servers)) {
            log.error("One or more of the specified KDB processes do not have a publisher defined in this manager!");
            throw new KdbPublisherDoesNotExistException();
        }
        for (KdbProcess server : servers) {
            this.publishers.get((Object)server).publish(tables);
        }
    }

    public List<KdbProcess> getTargetProcesses() {
        return Collections.list(this.publishers.keys());
    }

    public void disconnect(KdbProcess server) throws KdbPublisherDoesNotExistException {
        if (!this.publishers.containsKey((Object)server)) {
            log.error("The specified KDB process does not exist within this manager [ Process: {} ]", (Object)server);
            throw new KdbPublisherDoesNotExistException(server.toString());
        }
        log.info("Disconnect request received for server: {}", (Object)server);
        this.publishers.get((Object)server).disconnect();
        this.publishers.remove((Object)server);
    }

    public void shutdown() {
        ((ConcurrentHashMap.KeySetView)this.publishers.keySet()).forEach(this::disconnect);
    }
}

