/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.query;

import com.buabook.kdb.connection.KdbConnection;
import com.buabook.kdb.connection.KdbProcess;
import com.buabook.kdb.data.KdbDict;
import com.buabook.kdb.exceptions.KdbTargetProcessUnavailableException;
import com.buabook.kdb.exceptions.QueryExecutionFailedException;

public abstract class KdbQuery
implements AutoCloseable {
    KdbConnection connection;

    public KdbQuery(KdbProcess target) throws KdbTargetProcessUnavailableException {
        this.connection = new KdbConnection(target);
        this.connection.connect();
    }

    public KdbQuery(KdbConnection existingConnection) throws KdbTargetProcessUnavailableException {
        this.connection = existingConnection;
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
    }

    @Override
    public void close() {
        if (!this.connection.isConnected()) {
            return;
        }
        this.connection.disconnect();
    }

    public abstract Object query(String var1) throws QueryExecutionFailedException;

    public abstract Object query(String var1, KdbDict var2) throws QueryExecutionFailedException;
}

