/*
 * Decompiled with CFR 0.152.
 */
package com.buabook.kdb.query;

import com.buabook.kdb.connection.KdbConnection;
import com.buabook.kdb.connection.KdbProcess;
import com.buabook.kdb.data.KdbDict;
import com.buabook.kdb.exceptions.KdbTargetProcessUnavailableException;
import com.buabook.kdb.exceptions.QueryExecutionFailedException;
import com.buabook.kdb.query.KdbQuery;
import com.google.common.base.Stopwatch;
import com.kx.c;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdbSyncQuery
extends KdbQuery {
    private static final Logger log = LoggerFactory.getLogger(KdbSyncQuery.class);

    public KdbSyncQuery(KdbProcess target) throws KdbTargetProcessUnavailableException {
        super(target);
    }

    public KdbSyncQuery(KdbConnection existingConnection) throws KdbTargetProcessUnavailableException {
        super(existingConnection);
    }

    @Override
    public Object query(String query) throws QueryExecutionFailedException {
        return this.query(query, null);
    }

    @Override
    public Object query(String query, KdbDict arguments) throws QueryExecutionFailedException {
        if (!this.connection.isConnected()) {
            log.warn("Underlying connection to the kdb process ({}) has disconnected. Attempting to reconnect.", (Object)this.connection.getRemoteProcess());
            log.warn("NOTE: Query (and calling thread) will be pending until the process reconnects.");
            this.connection.reconnect();
        }
        Object queryResult = null;
        Stopwatch queryTime = null;
        try {
            queryTime = Stopwatch.createStarted();
            if (arguments == null) {
                log.debug("Running synchronous query [ Process: {} ] [ Query: {} ]", (Object)this.connection.getRemoteProcess(), (Object)query);
                queryResult = this.connection.getConnection().k(query);
            } else {
                log.debug("Running synchronous query [ Process: {} ] [ Query: {} ] [ Args: {} ]", new Object[]{this.connection.getRemoteProcess(), query, arguments});
                queryResult = this.connection.getConnection().k(query, arguments.convertToDict());
            }
            queryTime.stop();
        }
        catch (c.KException e) {
            log.error("Failed to execute synchronous query [ Process: {} ] [ Query: {} ]. Error - {}", new Object[]{this.connection.getRemoteProcess(), query, e.getMessage()});
            throw new QueryExecutionFailedException(this.connection.getRemoteProcess().toString(), e);
        }
        catch (IOException e) {
            log.error("Low level I/O exception has occurred during synchronous query. Will attempt to reconnect on next query. [ Process: {} ]. Error - {}" + e.getMessage(), (Object)this.connection.getRemoteProcess(), (Object)e.getMessage());
            this.connection.disconnect();
            throw new QueryExecutionFailedException(this.connection.getRemoteProcess().toString(), e);
        }
        log.debug("Query returned OK [ Process: {} ] [ Result: {} ] [ Query Time: {} ]", new Object[]{this.connection.getRemoteProcess(), queryResult, queryTime});
        return queryResult;
    }
}

