/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.Request;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class CaffeineProxyManager<K>
extends AbstractProxyManager<K> {
    private final Cache<K, RemoteBucketState> cache;

    public CaffeineProxyManager(Caffeine<? super K, ? super RemoteBucketState> builder, Duration keepAfterRefillDuration) {
        this(builder, keepAfterRefillDuration, ClientSideConfig.getDefault());
    }

    public CaffeineProxyManager(Caffeine<? super K, ? super RemoteBucketState> builder, final Duration keepAfterRefillDuration, final ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.cache = builder.expireAfter(new Expiry<K, RemoteBucketState>(){

            public long expireAfterCreate(K key, RemoteBucketState bucketState, long currentTime) {
                long currentTimeNanos = CaffeineProxyManager.getCurrentTime(clientSideConfig);
                long nanosToFullRefill = bucketState.calculateFullRefillingTime(currentTimeNanos);
                return nanosToFullRefill + keepAfterRefillDuration.toNanos();
            }

            public long expireAfterUpdate(K key, RemoteBucketState bucketState, long currentTime, long currentDuration) {
                long currentTimeNanos = CaffeineProxyManager.getCurrentTime(clientSideConfig);
                long nanosToFullRefill = bucketState.calculateFullRefillingTime(currentTimeNanos);
                return nanosToFullRefill + keepAfterRefillDuration.toNanos();
            }

            public long expireAfterRead(K key, RemoteBucketState bucketState, long currentTime, long currentDuration) {
                long currentTimeNanos = CaffeineProxyManager.getCurrentTime(clientSideConfig);
                long nanosToFullRefill = bucketState.calculateFullRefillingTime(currentTimeNanos);
                return nanosToFullRefill + keepAfterRefillDuration.toNanos();
            }
        }).build();
    }

    public Cache<K, RemoteBucketState> getCache() {
        return this.cache;
    }

    public <T> CommandResult<T> execute(K key, Request<T> request) {
        CommandResult[] resultHolder = new CommandResult[1];
        this.cache.asMap().compute(key, (k, previousState) -> {
            Long clientSideTime = request.getClientSideTime();
            long timeNanos = clientSideTime != null ? clientSideTime : System.currentTimeMillis() * 1000000L;
            final RemoteBucketState[] stateHolder = new RemoteBucketState[]{previousState == null ? null : previousState.copy()};
            MutableBucketEntry entry = new MutableBucketEntry(){

                public boolean exists() {
                    return stateHolder[0] != null;
                }

                public void set(RemoteBucketState state) {
                    stateHolder[0] = state;
                }

                public RemoteBucketState get() {
                    return stateHolder[0];
                }
            };
            resultHolder[0] = request.getCommand().execute(entry, timeNanos);
            return stateHolder[0];
        });
        return resultHolder[0];
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        CommandResult<T> result = this.execute(key, request);
        return CompletableFuture.completedFuture(result);
    }

    public void removeProxy(K key) {
        this.cache.asMap().remove(key);
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        this.cache.asMap().remove(key);
        return CompletableFuture.completedFuture(null);
    }

    private static long getCurrentTime(ClientSideConfig clientSideConfig) {
        Optional clock = clientSideConfig.getClientSideClock();
        return clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
    }
}

