/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.distributed.proxy.AsyncProxyManager;
import io.github.bucket4j.distributed.proxy.RemoteBucketBuilder;
import java.util.Optional;
import java.util.function.Function;

public interface ProxyManager<K> {
    public RemoteBucketBuilder<K> builder();

    public Optional<BucketConfiguration> getProxyConfiguration(K var1);

    public void removeProxy(K var1);

    public boolean isAsyncModeSupported();

    public AsyncProxyManager<K> asAsync() throws UnsupportedOperationException;

    default public <K1> ProxyManager<K1> withMapper(final Function<? super K1, ? extends K> mapper) {
        return new ProxyManager<K1>(){

            @Override
            public RemoteBucketBuilder<K1> builder() {
                return ProxyManager.this.builder().withMapper(mapper);
            }

            @Override
            public Optional<BucketConfiguration> getProxyConfiguration(K1 key) {
                return ProxyManager.this.getProxyConfiguration(mapper.apply(key));
            }

            @Override
            public void removeProxy(K1 key) {
                ProxyManager.this.removeProxy(mapper.apply(key));
            }

            @Override
            public boolean isAsyncModeSupported() {
                return ProxyManager.this.isAsyncModeSupported();
            }

            @Override
            public AsyncProxyManager<K1> asAsync() throws UnsupportedOperationException {
                return ProxyManager.this.asAsync().withMapper(mapper);
            }

            @Override
            public <K2> ProxyManager<K2> withMapper(Function<? super K2, ? extends K1> innerMapper) {
                return ProxyManager.this.withMapper(mapper.compose(innerMapper));
            }
        };
    }
}

