/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.skiponzero;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.CommandExecutor;
import io.github.bucket4j.distributed.proxy.optimization.OptimizationListener;
import io.github.bucket4j.distributed.remote.BucketEntryWrapper;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.commands.CreateSnapshotCommand;
import io.github.bucket4j.distributed.remote.commands.MultiCommand;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

class SkipSyncOnZeroCommandExecutor
implements CommandExecutor,
AsyncCommandExecutor {
    private static final int ORIGINAL_COMMAND_INDEX = 0;
    private static final int GET_SNAPSHOT_COMMAND_INDEX = 1;
    private final CommandExecutor originalExecutor;
    private final AsyncCommandExecutor originalAsyncExecutor;
    private final OptimizationListener listener;
    private final TimeMeter timeMeter;
    private RemoteBucketState state;
    private long lastSyncTimeNanos;

    SkipSyncOnZeroCommandExecutor(CommandExecutor originalExecutor, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = originalExecutor;
        this.originalAsyncExecutor = null;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    SkipSyncOnZeroCommandExecutor(AsyncCommandExecutor originalAsyncExecutor, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = null;
        this.originalAsyncExecutor = originalAsyncExecutor;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    @Override
    public <T> CommandResult<T> execute(RemoteCommand<T> command) {
        CommandResult<T> localResult = this.tryExecuteLocally(command);
        if (localResult != null) {
            this.listener.incrementSkipCount(1);
            return localResult;
        }
        MultiCommand remoteCommand = this.prepareRemoteCommand(command);
        CommandResult<MultiResult> remoteResult = this.originalExecutor.execute(remoteCommand);
        this.rememberRemoteCommandResult(remoteResult);
        return remoteResult.isError() ? remoteResult : remoteResult.getData().getResults().get(0);
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(RemoteCommand<T> command) {
        CommandResult<T> result = this.tryExecuteLocally(command);
        if (result != null) {
            this.listener.incrementSkipCount(1);
            return CompletableFuture.completedFuture(result);
        }
        MultiCommand remoteCommand = this.prepareRemoteCommand(command);
        CompletableFuture<CommandResult<MultiResult>> resultFuture = this.originalAsyncExecutor.executeAsync(remoteCommand);
        return resultFuture.thenApply(remoteResult -> {
            this.rememberRemoteCommandResult((CommandResult<MultiResult>)remoteResult);
            return remoteResult.isError() ? remoteResult : ((MultiResult)remoteResult.getData()).getResults().get(0);
        });
    }

    private <T> CommandResult<T> tryExecuteLocally(RemoteCommand<T> command) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        long commandConsumeTokens = command.estimateTokensToConsume();
        if (this.isNeedToExecuteRemoteImmediately(command, commandConsumeTokens, currentTimeNanos)) {
            return null;
        }
        BucketEntryWrapper entry = new BucketEntryWrapper(this.state.copy());
        CommandResult<T> result = command.execute(entry, currentTimeNanos);
        long locallyConsumedTokens = command.getConsumedTokens(result.getData());
        if (locallyConsumedTokens == Long.MAX_VALUE) {
            return null;
        }
        if (!this.isLocalExecutionResultSatisfiesThreshold(locallyConsumedTokens)) {
            return null;
        }
        if (entry.isStateModified()) {
            this.state = entry.get();
        }
        if (locallyConsumedTokens > 0L) {
            return null;
        }
        return result;
    }

    private boolean isLocalExecutionResultSatisfiesThreshold(long locallyConsumedTokens) {
        return locallyConsumedTokens != Long.MAX_VALUE && locallyConsumedTokens >= 0L;
    }

    private <T> boolean isNeedToExecuteRemoteImmediately(RemoteCommand<T> command, long commandConsumeTokens, long currentTimeNanos) {
        if (this.state == null) {
            return true;
        }
        if (commandConsumeTokens == 0L) {
            return true;
        }
        if (command.isImmediateSyncRequired(0L, currentTimeNanos - this.lastSyncTimeNanos)) {
            return true;
        }
        return commandConsumeTokens == Long.MAX_VALUE || commandConsumeTokens < 0L;
    }

    private <T> MultiCommand prepareRemoteCommand(RemoteCommand<T> command) {
        ArrayList commands = new ArrayList(3);
        commands.add(command);
        commands.add(new CreateSnapshotCommand());
        return new MultiCommand(commands);
    }

    private void rememberRemoteCommandResult(CommandResult<MultiResult> remoteResult) {
        CommandResult<MultiResult> snapshotResult;
        this.lastSyncTimeNanos = this.timeMeter.currentTimeNanos();
        CommandResult<MultiResult> commandResult = snapshotResult = remoteResult.isError() ? remoteResult : remoteResult.getData().getResults().get(1);
        if (snapshotResult.isError()) {
            this.state = null;
            return;
        }
        this.state = (RemoteBucketState)((Object)snapshotResult.getData());
    }
}

