/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.predictive;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.CommandExecutor;
import io.github.bucket4j.distributed.proxy.optimization.DelayParameters;
import io.github.bucket4j.distributed.proxy.optimization.OptimizationListener;
import io.github.bucket4j.distributed.proxy.optimization.PredictionParameters;
import io.github.bucket4j.distributed.proxy.optimization.predictive.Sampling;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeAsMuchAsPossibleCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeIgnoringRateLimitsCommand;
import io.github.bucket4j.distributed.remote.commands.CreateSnapshotCommand;
import io.github.bucket4j.distributed.remote.commands.MultiCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class PredictiveCommandExecutor
implements CommandExecutor,
AsyncCommandExecutor {
    private static final int ORIGINAL_COMMAND_INDEX = 1;
    private static final int GET_SNAPSHOT_COMMAND_INDEX = 2;
    private final CommandExecutor originalExecutor;
    private final AsyncCommandExecutor originalAsyncExecutor;
    private final DelayParameters delayParameters;
    private final OptimizationListener listener;
    private final TimeMeter timeMeter;
    private final Sampling sampling;
    private RemoteBucketState state;
    private long postponedToConsumeTokens;
    private long speculativelyConsumedByPredictionTokens;

    PredictiveCommandExecutor(CommandExecutor originalExecutor, DelayParameters delayParameters, PredictionParameters predictionParameters, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = originalExecutor;
        this.originalAsyncExecutor = null;
        this.sampling = new Sampling(predictionParameters);
        this.delayParameters = delayParameters;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    PredictiveCommandExecutor(AsyncCommandExecutor originalAsyncExecutor, DelayParameters delayParameters, PredictionParameters predictionParameters, OptimizationListener listener, TimeMeter timeMeter) {
        this.originalExecutor = null;
        this.originalAsyncExecutor = originalAsyncExecutor;
        this.sampling = new Sampling(predictionParameters);
        this.delayParameters = delayParameters;
        this.listener = listener;
        this.timeMeter = timeMeter;
    }

    @Override
    public <T> CommandResult<T> execute(RemoteCommand<T> command) {
        CommandResult<T> result = this.tryConsumeLocally(command);
        if (result != null) {
            this.listener.incrementSkipCount(1);
            return result;
        }
        MultiCommand remoteCommand = this.prepareRemoteCommand(command);
        CommandResult<MultiResult> remoteResult = this.originalExecutor.execute(remoteCommand);
        this.rememberRemoteCommandResult(remoteCommand, remoteResult);
        return remoteResult.isError() ? remoteResult : remoteResult.getData().getResults().get(1);
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(RemoteCommand<T> command) {
        CommandResult<T> result = this.tryConsumeLocally(command);
        if (result != null) {
            this.listener.incrementSkipCount(1);
            return CompletableFuture.completedFuture(result);
        }
        MultiCommand remoteCommand = this.prepareRemoteCommand(command);
        CompletableFuture<CommandResult<MultiResult>> resultFuture = this.originalAsyncExecutor.executeAsync(remoteCommand);
        return resultFuture.thenApply(remoteResult -> {
            this.rememberRemoteCommandResult(remoteCommand, (CommandResult<MultiResult>)remoteResult);
            return remoteResult.isError() ? remoteResult : ((MultiResult)remoteResult.getData()).getResults().get(1);
        });
    }

    private <T> CommandResult<T> tryConsumeLocally(RemoteCommand<T> command) {
        MutableBucketEntry entry;
        MultiResult multiResult;
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        if (this.isNeedToExecuteRemoteImmediately(command, currentTimeNanos)) {
            return null;
        }
        long predictedConsumptionSinceLastSync = this.sampling.predictedConsumptionByOthersSinceLastSync(currentTimeNanos);
        if (predictedConsumptionSinceLastSync == Long.MAX_VALUE) {
            return null;
        }
        long predictedConsumptionByOthersSinceLastLocalCall = predictedConsumptionSinceLastSync - this.speculativelyConsumedByPredictionTokens;
        if (predictedConsumptionByOthersSinceLastLocalCall < 0L) {
            predictedConsumptionByOthersSinceLastLocalCall = 0L;
        }
        ConsumeAsMuchAsPossibleCommand consumeByPredictionCommand = new ConsumeAsMuchAsPossibleCommand(predictedConsumptionByOthersSinceLastLocalCall);
        List<RemoteCommand<?>> commands = Arrays.asList(consumeByPredictionCommand, command);
        MultiCommand multiCommand = new MultiCommand(commands);
        if (multiCommand.getConsumedTokens(multiResult = multiCommand.execute(entry = new MutableBucketEntry(this.state.copy()), currentTimeNanos).getData()) == Long.MAX_VALUE) {
            return null;
        }
        long locallyConsumedTokens = command.getConsumedTokens(multiResult.getResults().get(1).getData());
        if (!this.isLocalExecutionResultSatisfiesThreshold(locallyConsumedTokens)) {
            return null;
        }
        this.postponedToConsumeTokens += locallyConsumedTokens;
        this.speculativelyConsumedByPredictionTokens += predictedConsumptionByOthersSinceLastLocalCall;
        if (entry.isStateModified()) {
            this.state = entry.get();
        }
        return multiResult.getResults().get(1);
    }

    private boolean isLocalExecutionResultSatisfiesThreshold(long locallyConsumedTokens) {
        if (locallyConsumedTokens == Long.MAX_VALUE || this.postponedToConsumeTokens + locallyConsumedTokens < 0L) {
            return false;
        }
        return this.postponedToConsumeTokens + locallyConsumedTokens <= this.delayParameters.maxUnsynchronizedTokens;
    }

    private <T> boolean isNeedToExecuteRemoteImmediately(RemoteCommand<T> command, long currentTimeNanos) {
        if (this.sampling.isNeedToExecuteRemoteImmediately(currentTimeNanos)) {
            return true;
        }
        long lastSyncTimeNanos = this.sampling.getLastSyncTimeNanos();
        if (currentTimeNanos - lastSyncTimeNanos > this.delayParameters.maxUnsynchronizedTimeoutNanos) {
            return true;
        }
        if (command.isImmediateSyncRequired(this.postponedToConsumeTokens, currentTimeNanos - lastSyncTimeNanos)) {
            return true;
        }
        long commandTokens = command.estimateTokensToConsume();
        if (commandTokens == Long.MAX_VALUE || commandTokens + this.postponedToConsumeTokens < 0L) {
            return true;
        }
        return commandTokens + this.postponedToConsumeTokens > this.delayParameters.maxUnsynchronizedTokens;
    }

    private <T> MultiCommand prepareRemoteCommand(RemoteCommand<T> command) {
        ArrayList commands = new ArrayList(3);
        commands.add(new ConsumeIgnoringRateLimitsCommand(this.postponedToConsumeTokens));
        commands.add(command);
        commands.add(new CreateSnapshotCommand());
        return new MultiCommand(commands);
    }

    private void rememberRemoteCommandResult(MultiCommand multiCommand, CommandResult<MultiResult> commandResult) {
        CommandResult<MultiResult> snapshotResult;
        this.postponedToConsumeTokens = 0L;
        this.speculativelyConsumedByPredictionTokens = 0L;
        CommandResult<MultiResult> commandResult2 = snapshotResult = commandResult.isError() ? commandResult : commandResult.getData().getResults().get(2);
        if (snapshotResult.isError()) {
            this.state = null;
            this.sampling.clear();
            return;
        }
        this.state = (RemoteBucketState)((Object)snapshotResult.getData());
        long now = this.timeMeter.currentTimeNanos();
        long consumedTokens = multiCommand.getConsumedTokens(commandResult.getData());
        this.sampling.rememberRemoteCommandResult(consumedTokens, this.state.getRemoteStat().getConsumedTokens(), now);
    }
}

