/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.serialization;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.DataOutputSerializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class InternalSerializationHelper {
    public static byte[] serializeState(RemoteBucketState state, Version backwardCompatibilityVersion) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteStream);
            RemoteBucketState.SERIALIZATION_HANDLE.serialize(DataOutputSerializationAdapter.INSTANCE, output, state, backwardCompatibilityVersion, Scope.PERSISTED_STATE);
            output.close();
            byteStream.close();
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static RemoteBucketState deserializeState(byte[] bytes) {
        RemoteBucketState remoteBucketState;
        DataInputStream inputSteam = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            remoteBucketState = RemoteBucketState.SERIALIZATION_HANDLE.deserialize(DataOutputSerializationAdapter.INSTANCE, inputSteam);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputSteam.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        inputSteam.close();
        return remoteBucketState;
    }

    public static byte[] serializeRequest(Request<?> request) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteStream);
            Request.SERIALIZATION_HANDLE.serialize(DataOutputSerializationAdapter.INSTANCE, output, request, request.getBackwardCompatibilityVersion(), Scope.REQUEST);
            output.close();
            byteStream.close();
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> Request<T> deserializeRequest(byte[] bytes) {
        Request<?> request;
        DataInputStream inputSteam = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            request = Request.SERIALIZATION_HANDLE.deserialize(DataOutputSerializationAdapter.INSTANCE, inputSteam);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputSteam.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        inputSteam.close();
        return request;
    }

    public static byte[] serializeResult(CommandResult<?> result, Version backwardCompatibilityVersion) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(byteStream);
            CommandResult.SERIALIZATION_HANDLE.serialize(DataOutputSerializationAdapter.INSTANCE, output, result, backwardCompatibilityVersion, Scope.RESPONSE);
            output.close();
            byteStream.close();
            return byteStream.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> CommandResult<T> deserializeResult(byte[] bytes, Version backwardCompatibilityVersion) {
        CommandResult<?> commandResult;
        DataInputStream inputSteam = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            commandResult = CommandResult.SERIALIZATION_HANDLE.deserialize(DataOutputSerializationAdapter.INSTANCE, inputSteam);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputSteam.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        inputSteam.close();
        return commandResult;
    }
}

