/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast;

import com.hazelcast.map.IMap;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.AbstractLockBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.LockBasedTransaction;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class HazelcastLockBasedProxyManager<K>
extends AbstractLockBasedProxyManager<K> {
    private final IMap<K, byte[]> map;

    public HazelcastLockBasedProxyManager(IMap<K, byte[]> map) {
        this(map, ClientSideConfig.getDefault());
    }

    public HazelcastLockBasedProxyManager(IMap<K, byte[]> map, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.map = Objects.requireNonNull(map);
    }

    public void removeProxy(K key) {
        this.map.remove(key);
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    public boolean isExpireAfterWriteSupported() {
        return true;
    }

    protected LockBasedTransaction allocateTransaction(final K key, Optional<Long> requestTimeout) {
        return new LockBasedTransaction(){

            public void begin(Optional<Long> requestTimeout) {
            }

            public void rollback() {
            }

            public void commit(Optional<Long> requestTimeout) {
            }

            public byte[] lockAndGet(Optional<Long> requestTimeout) {
                HazelcastLockBasedProxyManager.this.map.lock(key);
                return (byte[])HazelcastLockBasedProxyManager.this.map.get(key);
            }

            public void unlock() {
                HazelcastLockBasedProxyManager.this.map.unlock(key);
            }

            public void create(byte[] data, RemoteBucketState newState, Optional<Long> requestTimeout) {
                this.save(data, newState);
            }

            public void update(byte[] data, RemoteBucketState newState, Optional<Long> requestTimeout) {
                this.save(data, newState);
            }

            private void save(byte[] data, RemoteBucketState newState) {
                ExpirationAfterWriteStrategy expiration = HazelcastLockBasedProxyManager.this.getClientSideConfig().getExpirationAfterWriteStrategy().orElse(null);
                if (expiration == null) {
                    HazelcastLockBasedProxyManager.this.map.put(key, (Object)data);
                } else {
                    long currentTimeNanos = HazelcastLockBasedProxyManager.this.getClientSideConfig().getClientSideClock().orElse(TimeMeter.SYSTEM_MILLISECONDS).currentTimeNanos();
                    long ttlMillis = expiration.calculateTimeToLiveMillis(newState, currentTimeNanos);
                    if (ttlMillis > 0L) {
                        HazelcastLockBasedProxyManager.this.map.put(key, (Object)data, ttlMillis, TimeUnit.MILLISECONDS);
                    } else {
                        HazelcastLockBasedProxyManager.this.map.put(key, (Object)data);
                    }
                }
            }

            public void release() {
            }
        };
    }
}

