/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.ExtendedMapEntry;
import io.github.bucket4j.util.ComparableByContent;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class VersionedBackupProcessor<K>
implements EntryProcessor<K, byte[], byte[]>,
ComparableByContent<VersionedBackupProcessor> {
    private static final long serialVersionUID = 1L;
    private final byte[] state;
    private final Long ttlMillis;

    public VersionedBackupProcessor(byte[] state, Long ttlMillis) {
        this.state = state;
        this.ttlMillis = ttlMillis;
    }

    public byte[] getState() {
        return this.state;
    }

    public Long getTtlMillis() {
        return this.ttlMillis;
    }

    public boolean equalsByContent(VersionedBackupProcessor other) {
        return Arrays.equals(this.state, other.state) && Objects.equals(this.ttlMillis, other.ttlMillis);
    }

    public byte[] process(Map.Entry<K, byte[]> entry) {
        if (this.ttlMillis == null) {
            entry.setValue(this.state);
        } else {
            ExtendedMapEntry extendedMapEntry = (ExtendedMapEntry)entry;
            extendedMapEntry.setValue((Object)this.state, this.ttlMillis.longValue(), TimeUnit.MILLISECONDS);
        }
        return null;
    }
}

