/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.TypedStreamDeserializer;
import io.github.bucket4j.grid.hazelcast.HazelcastOffloadableEntryProcessor;
import io.github.bucket4j.grid.hazelcast.serialization.SerializationUtilities;
import java.io.IOException;

public class HazelcastOffloadableEntryProcessorSerializer
implements StreamSerializer<HazelcastOffloadableEntryProcessor>,
TypedStreamDeserializer<HazelcastOffloadableEntryProcessor> {
    private final int typeId;

    public HazelcastOffloadableEntryProcessorSerializer(int typeId) {
        this.typeId = typeId;
    }

    public HazelcastOffloadableEntryProcessorSerializer() {
        this.typeId = SerializationUtilities.getSerializerTypeId(this.getClass());
    }

    public Class<HazelcastOffloadableEntryProcessor> getSerializableType() {
        return HazelcastOffloadableEntryProcessor.class;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void destroy() {
    }

    public void write(ObjectDataOutput out, HazelcastOffloadableEntryProcessor serializable) throws IOException {
        out.writeByteArray(serializable.getRequestBytes());
        out.writeString(serializable.getExecutorName());
    }

    public HazelcastOffloadableEntryProcessor read(ObjectDataInput in) throws IOException {
        return this.read0(in);
    }

    public HazelcastOffloadableEntryProcessor read(ObjectDataInput in, Class aClass) throws IOException {
        return this.read0(in);
    }

    private HazelcastOffloadableEntryProcessor read0(ObjectDataInput in) throws IOException {
        byte[] commandBytes = in.readByteArray();
        String executorName = in.readString();
        return new HazelcastOffloadableEntryProcessor(commandBytes, executorName);
    }
}

