/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast;

import com.hazelcast.map.IMap;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.AbstractLockBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.LockBasedTransaction;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import java.util.Objects;

public class HazelcastLockBasedProxyManager<K>
extends AbstractLockBasedProxyManager<K> {
    private final IMap<K, byte[]> map;

    public HazelcastLockBasedProxyManager(IMap<K, byte[]> map) {
        this(map, ClientSideConfig.getDefault());
    }

    public HazelcastLockBasedProxyManager(IMap<K, byte[]> map, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.map = Objects.requireNonNull(map);
    }

    public void removeProxy(K key) {
        this.map.remove(key);
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    protected LockBasedTransaction allocateTransaction(final K key) {
        return new LockBasedTransaction(){

            public void begin() {
            }

            public void rollback() {
            }

            public void commit() {
            }

            public byte[] lockAndGet() {
                HazelcastLockBasedProxyManager.this.map.lock(key);
                return (byte[])HazelcastLockBasedProxyManager.this.map.get(key);
            }

            public void unlock() {
                HazelcastLockBasedProxyManager.this.map.unlock(key);
            }

            public void create(byte[] data, RemoteBucketState newState) {
                HazelcastLockBasedProxyManager.this.map.put(key, (Object)data);
            }

            public void update(byte[] data, RemoteBucketState newState) {
                HazelcastLockBasedProxyManager.this.map.put(key, (Object)data);
            }

            public void release() {
            }
        };
    }
}

