/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast.serialization;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.nio.serialization.Serializer;
import io.github.bucket4j.grid.hazelcast.serialization.HazelcastEntryProcessorSerializer;
import io.github.bucket4j.grid.hazelcast.serialization.HazelcastOffloadableEntryProcessorSerializer;
import io.github.bucket4j.grid.hazelcast.serialization.InvalidConfigurationParameterException;
import io.github.bucket4j.grid.hazelcast.serialization.MissingConfigurationParameterException;
import io.github.bucket4j.grid.hazelcast.serialization.SimpleBackupProcessorSerializer;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class SerializationUtilities {
    public static final String TYPE_ID_BASE_PROP_NAME = "bucket4j.hazelcast.serializer.type_id_base";
    private static final Map<Class<? extends Serializer>, Integer> serializerTypeIdOffsets = Map.ofEntries(new AbstractMap.SimpleEntry<Class<HazelcastEntryProcessorSerializer>, Integer>(HazelcastEntryProcessorSerializer.class, 0), new AbstractMap.SimpleEntry<Class<SimpleBackupProcessorSerializer>, Integer>(SimpleBackupProcessorSerializer.class, 1), new AbstractMap.SimpleEntry<Class<HazelcastOffloadableEntryProcessorSerializer>, Integer>(HazelcastOffloadableEntryProcessorSerializer.class, 2));

    public static int getSerializerTypeId(Class<? extends Serializer> serializerType) {
        Optional<Integer> typeIdBase = SerializationUtilities.getSerializersTypeIdBase();
        if (typeIdBase.isEmpty()) {
            String msg = MessageFormat.format("Missing TypeIdBase number, impossible to load Bucket4j custom serializers. It must be provided in form of Environment Variable or System Property, both using the following key: [{0}]", TYPE_ID_BASE_PROP_NAME);
            throw new MissingConfigurationParameterException(msg);
        }
        return SerializationUtilities.getSerializerTypeId(serializerType, typeIdBase.get());
    }

    public static int getSerializerTypeId(Class<? extends Serializer> serializerType, int typeIdBase) {
        return typeIdBase + SerializationUtilities.getSerializerTypeIdOffset(serializerType);
    }

    private static Optional<Integer> getSerializersTypeIdBase() {
        return Optional.ofNullable(SerializationUtilities.getSerializerTypeIdBaseFromSystemProperty().orElseGet(() -> SerializationUtilities.getSerializerTypeIdBaseFromEnvironmentVariable().orElseGet(() -> null)));
    }

    private static int getSerializerTypeIdOffset(Class<? extends Serializer> serializerType) {
        if (serializerTypeIdOffsets.containsKey(serializerType)) {
            return serializerTypeIdOffsets.get(serializerType);
        }
        String msg = MessageFormat.format("The internal configuration does not include any offset for the serializerType [{0}]", serializerType);
        throw new IllegalStateException(msg);
    }

    private static Optional<Integer> getSerializerTypeIdBaseFromEnvironmentVariable() {
        return SerializationUtilities.getPropertyValueFromExternal(() -> System.getenv(TYPE_ID_BASE_PROP_NAME), "Environment Variable");
    }

    private static Optional<Integer> getSerializerTypeIdBaseFromSystemProperty() {
        return SerializationUtilities.getPropertyValueFromExternal(() -> System.getProperty(TYPE_ID_BASE_PROP_NAME), "System Property");
    }

    private static Optional<Integer> getPropertyValueFromExternal(Supplier<String> typeIdSupplier, String source) {
        Optional<Integer> retVal = Optional.empty();
        String typeIdBaseStr = typeIdSupplier.get();
        if (!StringUtil.isNullOrEmptyAfterTrim((String)typeIdBaseStr) && (retVal = SerializationUtilities.parseInteger(typeIdBaseStr)).isEmpty()) {
            String msg = MessageFormat.format("The {0} [{1}] has an invalid format. It must be a positive Integer.", source, TYPE_ID_BASE_PROP_NAME);
            throw new InvalidConfigurationParameterException(msg);
        }
        return retVal;
    }

    private static Optional<Integer> parseInteger(String strNum) {
        Optional<Integer> retVal = Optional.empty();
        if (null != strNum) {
            try {
                Integer d = Integer.parseInt(strNum.trim());
                retVal = Optional.of(d);
            }
            catch (NumberFormatException nfe) {
                retVal = Optional.empty();
            }
        }
        return retVal;
    }
}

