/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.ignite.thick;

import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.AbstractBinaryTransaction;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;

public class IgniteProxyManager<K>
extends AbstractProxyManager<K> {
    private final IgniteCache<K, byte[]> cache;

    public IgniteProxyManager(IgniteCache<K, byte[]> cache) {
        this(cache, ClientSideConfig.getDefault());
    }

    public IgniteProxyManager(IgniteCache<K, byte[]> cache, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.cache = Objects.requireNonNull(cache);
    }

    public <T> CommandResult<T> execute(K key, Request<T> request) {
        IgniteProcessor entryProcessor = new IgniteProcessor(request);
        byte[] resultBytes = (byte[])this.cache.invoke(key, entryProcessor, new Object[0]);
        return InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)request.getBackwardCompatibilityVersion());
    }

    public void removeProxy(K key) {
        this.cache.remove(key);
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        IgniteProcessor entryProcessor = new IgniteProcessor(request);
        IgniteFuture igniteFuture = this.cache.invokeAsync(key, entryProcessor, new Object[0]);
        Version backwardCompatibilityVersion = request.getBackwardCompatibilityVersion();
        CompletableFuture completableFuture = new CompletableFuture();
        igniteFuture.listen((IgniteInClosure & Serializable)completedIgniteFuture -> {
            try {
                byte[] resultBytes = (byte[])completedIgniteFuture.get();
                CommandResult result = InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)backwardCompatibilityVersion);
                completableFuture.complete(result);
            }
            catch (Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        });
        return completableFuture;
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        IgniteFuture igniteFuture = this.cache.removeAsync(key);
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        igniteFuture.listen((IgniteInClosure & Serializable)completedIgniteFuture -> {
            try {
                completedIgniteFuture.get();
                completableFuture.complete(null);
            }
            catch (Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        });
        return completableFuture;
    }

    private static class IgniteProcessor<K>
    implements Serializable,
    CacheEntryProcessor<K, byte[], byte[]> {
        private static final long serialVersionUID = 1L;
        private final byte[] requestBytes;

        private IgniteProcessor(Request<?> request) {
            this.requestBytes = InternalSerializationHelper.serializeRequest(request);
        }

        public byte[] process(final MutableEntry<K, byte[]> entry, Object ... arguments) throws EntryProcessorException {
            return new AbstractBinaryTransaction(this.requestBytes){

                public boolean exists() {
                    return entry.exists();
                }

                protected byte[] getRawState() {
                    return (byte[])entry.getValue();
                }

                protected void setRawState(byte[] newStateBytes, RemoteBucketState newState) {
                    entry.setValue((Object)newStateBytes);
                }
            }.execute();
        }
    }
}

