/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.ignite.thin.compute;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.grid.ignite.thin.ThinClientUtils;
import io.github.bucket4j.grid.ignite.thin.compute.Bucket4jComputeTask;
import io.github.bucket4j.grid.ignite.thin.compute.Bucket4jComputeTaskParams;
import io.github.bucket4j.grid.ignite.thin.compute.IgniteEntryProcessor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCompute;
import org.apache.ignite.client.IgniteClientFuture;

public class IgniteThinClientProxyManager<K>
extends AbstractProxyManager<K> {
    private final ClientCache<K, byte[]> cache;
    private final ClientCompute clientCompute;

    public IgniteThinClientProxyManager(ClientCache<K, byte[]> cache, ClientCompute clientCompute) {
        this(cache, clientCompute, ClientSideConfig.getDefault());
    }

    public IgniteThinClientProxyManager(ClientCache<K, byte[]> cache, ClientCompute clientCompute, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.cache = Objects.requireNonNull(cache);
        this.clientCompute = Objects.requireNonNull(clientCompute);
    }

    public <T> CommandResult<T> execute(K key, Request<T> request) {
        IgniteEntryProcessor entryProcessor = new IgniteEntryProcessor(request);
        Bucket4jComputeTaskParams<K> taskParams = new Bucket4jComputeTaskParams<K>(this.cache.getName(), key, entryProcessor);
        try {
            byte[] resultBytes = (byte[])this.clientCompute.execute(Bucket4jComputeTask.JOB_NAME, taskParams);
            return InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)request.getBackwardCompatibilityVersion());
        }
        catch (InterruptedException e) {
            throw BucketExceptions.executionException((Throwable)e);
        }
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        IgniteEntryProcessor entryProcessor = new IgniteEntryProcessor(request);
        Bucket4jComputeTaskParams<K> taskParams = new Bucket4jComputeTaskParams<K>(this.cache.getName(), key, entryProcessor);
        IgniteClientFuture igniteFuture = this.clientCompute.executeAsync2(Bucket4jComputeTask.JOB_NAME, taskParams);
        CompletableFuture completableFuture = ThinClientUtils.convertFuture(igniteFuture);
        Version backwardCompatibilityVersion = request.getBackwardCompatibilityVersion();
        return completableFuture.thenApply(resultBytes -> InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)backwardCompatibilityVersion));
    }

    public void removeProxy(K key) {
        this.cache.remove(key);
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        IgniteClientFuture igniteFuture = this.cache.removeAsync(key);
        return ThinClientUtils.convertFuture(igniteFuture).thenApply(result -> null);
    }
}

