/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.infinispan;

import io.github.bucket4j.distributed.remote.AbstractBinaryTransaction;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.util.ComparableByContent;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.util.function.SerializableFunction;

public class InfinispanProcessor<K, R>
implements SerializableFunction<EntryView.ReadWriteEntryView<K, byte[]>, byte[]>,
ComparableByContent<InfinispanProcessor> {
    private static final long serialVersionUID = 911L;
    private final byte[] requestBytes;

    public InfinispanProcessor(Request<R> request) {
        this.requestBytes = InternalSerializationHelper.serializeRequest(request);
    }

    public InfinispanProcessor(byte[] requestBytes) {
        this.requestBytes = requestBytes;
    }

    public byte[] apply(final EntryView.ReadWriteEntryView<K, byte[]> entry) {
        if (this.requestBytes.length == 0 && entry.find().isPresent()) {
            entry.remove();
            return new byte[0];
        }
        return new AbstractBinaryTransaction(this.requestBytes){

            public boolean exists() {
                return entry.find().isPresent();
            }

            protected byte[] getRawState() {
                return (byte[])entry.get();
            }

            protected void setRawState(byte[] newStateBytes, RemoteBucketState newState) {
                entry.set((Object)newStateBytes, new MetaParam.Writable[0]);
            }
        }.execute();
    }

    public boolean equalsByContent(InfinispanProcessor other) {
        return ComparableByContent.equals((Object)this.requestBytes, (Object)other.requestBytes);
    }

    public byte[] getRequestBytes() {
        return this.requestBytes;
    }
}

