/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.postgresql;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.distributed.jdbc.SQLProxyConfiguration;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.AbstractLockBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.LockBasedTransaction;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Objects;
import javax.sql.DataSource;

public class PostgreSQLadvisoryLockBasedProxyManager
extends AbstractLockBasedProxyManager<Long> {
    private final DataSource dataSource;
    private final SQLProxyConfiguration configuration;
    private final String removeSqlQuery;
    private final String updateSqlQuery;
    private final String insertSqlQuery;
    private final String selectSqlQuery;

    public PostgreSQLadvisoryLockBasedProxyManager(SQLProxyConfiguration configuration) {
        super(configuration.getClientSideConfig());
        this.dataSource = Objects.requireNonNull(configuration.getDataSource());
        this.configuration = configuration;
        this.removeSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", configuration.getTableName(), configuration.getIdName());
        this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=? WHERE {2}=?", configuration.getTableName(), configuration.getStateName(), configuration.getIdName());
        this.insertSqlQuery = MessageFormat.format("INSERT INTO {0}({1}, {2}) VALUES(?, ?)", configuration.getTableName(), configuration.getIdName(), configuration.getStateName());
        this.selectSqlQuery = MessageFormat.format("SELECT {0} FROM {1} WHERE {2} = ?", configuration.getStateName(), configuration.getTableName(), configuration.getIdName());
    }

    protected LockBasedTransaction allocateTransaction(final Long key) {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
        return new LockBasedTransaction(){

            public void begin() {
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public byte[] lockAndGet() {
                try {
                    String lockSQL = "SELECT pg_advisory_xact_lock(?)";
                    try (PreparedStatement lockStatement = connection.prepareStatement(lockSQL);){
                        lockStatement.setLong(1, key);
                        lockStatement.executeQuery();
                    }
                    try (PreparedStatement selectStatement = connection.prepareStatement(PostgreSQLadvisoryLockBasedProxyManager.this.selectSqlQuery);){
                        byte[] byArray;
                        block25: {
                            ResultSet rs;
                            block23: {
                                byte[] byArray2;
                                block24: {
                                    selectStatement.setLong(1, key);
                                    rs = selectStatement.executeQuery();
                                    try {
                                        if (!rs.next()) break block23;
                                        byArray2 = rs.getBytes(PostgreSQLadvisoryLockBasedProxyManager.this.configuration.getStateName());
                                        if (rs == null) break block24;
                                    }
                                    catch (Throwable throwable) {
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    rs.close();
                                }
                                return byArray2;
                            }
                            byArray = null;
                            if (rs == null) break block25;
                            rs.close();
                        }
                        return byArray;
                    }
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void update(byte[] data, RemoteBucketState newState) {
                try (PreparedStatement updateStatement = connection.prepareStatement(PostgreSQLadvisoryLockBasedProxyManager.this.updateSqlQuery);){
                    updateStatement.setBytes(1, data);
                    updateStatement.setLong(2, key);
                    updateStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void release() {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void create(byte[] data, RemoteBucketState newState) {
                try (PreparedStatement insertStatement = connection.prepareStatement(PostgreSQLadvisoryLockBasedProxyManager.this.insertSqlQuery);){
                    insertStatement.setLong(1, key);
                    insertStatement.setBytes(2, data);
                    insertStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void rollback() {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void commit() {
                try {
                    connection.commit();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void unlock() {
            }
        };
    }

    public void removeProxy(Long key) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement removeStatement = connection.prepareStatement(this.removeSqlQuery);){
            removeStatement.setLong(1, key);
            removeStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
    }
}

