/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.postgresql;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.distributed.jdbc.SQLProxyConfiguration;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.AbstractSelectForUpdateBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.LockAndGetResult;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.SelectForUpdateBasedTransaction;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;

public class PostgreSQLSelectForUpdateBasedProxyManager<K>
extends AbstractSelectForUpdateBasedProxyManager<K> {
    private final DataSource dataSource;
    private final SQLProxyConfiguration<K> configuration;
    private final String removeSqlQuery;
    private final String updateSqlQuery;
    private final String insertSqlQuery;
    private final String selectSqlQuery;

    public PostgreSQLSelectForUpdateBasedProxyManager(SQLProxyConfiguration<K> configuration) {
        this(configuration, ClientSideConfig.getDefault());
    }

    public PostgreSQLSelectForUpdateBasedProxyManager(SQLProxyConfiguration<K> configuration, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.dataSource = Objects.requireNonNull(configuration.getDataSource());
        this.configuration = configuration;
        this.removeSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", configuration.getTableName(), configuration.getIdName());
        this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=? WHERE {2}=?", configuration.getTableName(), configuration.getStateName(), configuration.getIdName());
        this.insertSqlQuery = MessageFormat.format("INSERT INTO {0}({1}, {2}) VALUES(?, null) ON CONFLICT({3}) DO NOTHING", configuration.getTableName(), configuration.getIdName(), configuration.getStateName(), configuration.getIdName());
        this.selectSqlQuery = MessageFormat.format("SELECT {0} FROM {1} WHERE {2} = ? FOR UPDATE", configuration.getStateName(), configuration.getTableName(), configuration.getIdName());
    }

    protected SelectForUpdateBasedTransaction allocateTransaction(final K key, Optional<Long> requestTimeoutNanos) {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
        return new SelectForUpdateBasedTransaction(){

            public void begin(Optional<Long> requestTimeoutNanos) {
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void rollback() {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void commit(Optional<Long> requestTimeoutNanos) {
                try {
                    connection.commit();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public LockAndGetResult tryLockAndGet(Optional<Long> requestTimeoutNanos) {
                try (PreparedStatement selectStatement = connection.prepareStatement(PostgreSQLSelectForUpdateBasedProxyManager.this.selectSqlQuery);){
                    LockAndGetResult lockAndGetResult;
                    block18: {
                        ResultSet rs;
                        block16: {
                            LockAndGetResult lockAndGetResult2;
                            block17: {
                                PostgreSQLSelectForUpdateBasedProxyManager.this.applyTimeout(selectStatement, requestTimeoutNanos);
                                PostgreSQLSelectForUpdateBasedProxyManager.this.configuration.getPrimaryKeyMapper().set(selectStatement, 1, key);
                                rs = selectStatement.executeQuery();
                                try {
                                    if (!rs.next()) break block16;
                                    byte[] data = rs.getBytes(PostgreSQLSelectForUpdateBasedProxyManager.this.configuration.getStateName());
                                    lockAndGetResult2 = LockAndGetResult.locked((byte[])data);
                                    if (rs == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return lockAndGetResult2;
                        }
                        lockAndGetResult = LockAndGetResult.notLocked();
                        if (rs == null) break block18;
                        rs.close();
                    }
                    return lockAndGetResult;
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public boolean tryInsertEmptyData(Optional<Long> requestTimeoutNanos) {
                boolean bl;
                block8: {
                    PreparedStatement insertStatement = connection.prepareStatement(PostgreSQLSelectForUpdateBasedProxyManager.this.insertSqlQuery);
                    try {
                        PostgreSQLSelectForUpdateBasedProxyManager.this.applyTimeout(insertStatement, requestTimeoutNanos);
                        PostgreSQLSelectForUpdateBasedProxyManager.this.configuration.getPrimaryKeyMapper().set(insertStatement, 1, key);
                        boolean bl2 = bl = insertStatement.executeUpdate() > 0;
                        if (insertStatement == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (insertStatement != null) {
                                try {
                                    insertStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new BucketExceptions.BucketExecutionException((Throwable)e);
                        }
                    }
                    insertStatement.close();
                }
                return bl;
            }

            public void update(byte[] data, RemoteBucketState newState, Optional<Long> requestTimeoutNanos) {
                try (PreparedStatement updateStatement = connection.prepareStatement(PostgreSQLSelectForUpdateBasedProxyManager.this.updateSqlQuery);){
                    PostgreSQLSelectForUpdateBasedProxyManager.this.applyTimeout(updateStatement, requestTimeoutNanos);
                    updateStatement.setBytes(1, data);
                    PostgreSQLSelectForUpdateBasedProxyManager.this.configuration.getPrimaryKeyMapper().set(updateStatement, 2, key);
                    updateStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void release() {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }
        };
    }

    public void removeProxy(K key) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement removeStatement = connection.prepareStatement(this.removeSqlQuery);){
            this.configuration.getPrimaryKeyMapper().set(removeStatement, 1, key);
            removeStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
    }
}

