/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.jedis.cas;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisBasedProxyManager
extends AbstractCompareAndSwapBasedProxyManager<byte[]> {
    private final JedisPool jedisPool;
    private final ExpirationAfterWriteStrategy expirationStrategy;
    private final byte[] scriptSetNxPx = "return redis.call('set', KEYS[1], ARGV[1], 'nx', 'px', ARGV[2])".getBytes(StandardCharsets.UTF_8);
    private final byte[] scriptCompareAndSwapPx = "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8);
    private final byte[] scriptSetNx = "return redis.call('set', KEYS[1], ARGV[1], 'nx')".getBytes(StandardCharsets.UTF_8);
    private final byte[] scriptCompareAndSwap = "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8);

    public static JedisBasedProxyManagerBuilder builderFor(JedisPool jedisPool) {
        return new JedisBasedProxyManagerBuilder(jedisPool);
    }

    private JedisBasedProxyManager(JedisBasedProxyManagerBuilder builder) {
        super(builder.getClientSideConfig());
        this.jedisPool = builder.jedisPool;
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(final byte[] key) {
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData() {
                return JedisBasedProxyManager.this.withResource(jedis -> Optional.ofNullable(jedis.get(key)));
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return JedisBasedProxyManager.this.compareAndSwap(key, originalData, newData, newState);
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public void removeProxy(byte[] key) {
        this.withResource(jedis -> jedis.del(key));
    }

    protected CompletableFuture<Void> removeAsync(byte[] key) {
        return this.withResource(jedis -> CompletableFuture.runAsync(() -> jedis.del(key)));
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    private Boolean compareAndSwap(byte[] key, byte[] originalData, byte[] newData, RemoteBucketState newState) {
        long ttlMillis = this.calculateTtlMillis(newState);
        if (ttlMillis > 0L) {
            if (originalData == null) {
                byte[][] keysAndArgs = new byte[][]{key, newData, this.encodeLong(ttlMillis)};
                Object res = this.withResource(jedis -> jedis.eval(this.scriptSetNxPx, 1, keysAndArgs));
                return res != null;
            }
            byte[][] keysAndArgs = new byte[][]{key, originalData, newData, this.encodeLong(ttlMillis)};
            Object res = this.withResource(jedis -> jedis.eval(this.scriptCompareAndSwapPx, 1, keysAndArgs));
            return res != null && !res.equals(0L);
        }
        if (originalData == null) {
            byte[][] keysAndArgs = new byte[][]{key, newData};
            Object res = this.withResource(jedis -> jedis.eval(this.scriptSetNx, 1, keysAndArgs));
            return res != null;
        }
        byte[][] keysAndArgs = new byte[][]{key, originalData, newData};
        Object res = this.withResource(jedis -> jedis.eval(this.scriptCompareAndSwap, 1, keysAndArgs));
        return res != null && !res.equals(0L);
    }

    private byte[] encodeLong(Long value) {
        return ("" + value).getBytes(StandardCharsets.UTF_8);
    }

    private <V> V withResource(Function<Jedis, V> fn) {
        try (Jedis jedis = this.jedisPool.getResource();){
            V v = fn.apply(jedis);
            return v;
        }
    }

    private long calculateTtlMillis(RemoteBucketState state) {
        Optional clock = this.getClientSideConfig().getClientSideClock();
        long currentTimeNanos = clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
        return this.expirationStrategy.calculateTimeToLiveMillis(state, currentTimeNanos);
    }

    public static class JedisBasedProxyManagerBuilder
    extends AbstractRedisProxyManagerBuilder<JedisBasedProxyManagerBuilder> {
        private final JedisPool jedisPool;

        private JedisBasedProxyManagerBuilder(JedisPool jedisPool) {
            this.jedisPool = Objects.requireNonNull(jedisPool);
        }

        public JedisBasedProxyManager build() {
            return new JedisBasedProxyManager(this);
        }
    }
}

