/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.jedis.cas;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class JedisBasedProxyManager
extends AbstractCompareAndSwapBasedProxyManager<byte[]> {
    private final Pool<Jedis> jedisPool;
    private final ExpirationAfterWriteStrategy expirationStrategy;

    public static JedisBasedProxyManagerBuilder builderFor(Pool<Jedis> jedisPool) {
        return new JedisBasedProxyManagerBuilder(jedisPool);
    }

    private JedisBasedProxyManager(JedisBasedProxyManagerBuilder builder) {
        super(builder.getClientSideConfig());
        this.jedisPool = builder.jedisPool;
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(final byte[] key) {
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData() {
                return JedisBasedProxyManager.this.withResource(jedis -> Optional.ofNullable(jedis.get(key)));
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return JedisBasedProxyManager.this.compareAndSwap(key, originalData, newData, newState);
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public void removeProxy(byte[] key) {
        this.withResource(jedis -> jedis.del(key));
    }

    protected CompletableFuture<Void> removeAsync(byte[] key) {
        return this.withResource(jedis -> CompletableFuture.runAsync(() -> jedis.del(key)));
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    private Boolean compareAndSwap(byte[] key, byte[] originalData, byte[] newData, RemoteBucketState newState) {
        long ttlMillis = this.calculateTtlMillis(newState);
        if (ttlMillis > 0L) {
            if (originalData == null) {
                byte[][] keysAndArgs = new byte[][]{key, newData, this.encodeLong(ttlMillis)};
                Object res = this.withResource(jedis -> jedis.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx', 'px', ARGV[2]) then return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs));
                return res != null && !res.equals(0L);
            }
            byte[][] keysAndArgs = new byte[][]{key, originalData, newData, this.encodeLong(ttlMillis)};
            Object res = this.withResource(jedis -> jedis.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs));
            return res != null && !res.equals(0L);
        }
        if (originalData == null) {
            byte[][] keysAndArgs = new byte[][]{key, newData};
            Object res = this.withResource(jedis -> jedis.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx') then return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs));
            return res != null && !res.equals(0L);
        }
        byte[][] keysAndArgs = new byte[][]{key, originalData, newData};
        Object res = this.withResource(jedis -> jedis.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs));
        return res != null && !res.equals(0L);
    }

    private byte[] encodeLong(Long value) {
        return ("" + value).getBytes(StandardCharsets.UTF_8);
    }

    private <V> V withResource(Function<Jedis, V> fn) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            V v = fn.apply(jedis);
            return v;
        }
    }

    private long calculateTtlMillis(RemoteBucketState state) {
        Optional clock = this.getClientSideConfig().getClientSideClock();
        long currentTimeNanos = clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
        return this.expirationStrategy.calculateTimeToLiveMillis(state, currentTimeNanos);
    }

    public static class JedisBasedProxyManagerBuilder
    extends AbstractRedisProxyManagerBuilder<JedisBasedProxyManagerBuilder> {
        private final Pool<Jedis> jedisPool;

        private JedisBasedProxyManagerBuilder(Pool<Jedis> jedisPool) {
            this.jedisPool = Objects.requireNonNull(jedisPool);
        }

        public JedisBasedProxyManager build() {
            return new JedisBasedProxyManager(this);
        }
    }
}

