/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.redisson.cas;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.redisson.api.RFuture;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanNotNullReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.command.CommandExecutor;

public class RedissonBasedProxyManager
extends AbstractCompareAndSwapBasedProxyManager<String> {
    public static RedisCommand<Boolean> SET = new RedisCommand("SET", (Convertor)new BooleanNotNullReplayConvertor());
    private final CommandExecutor commandExecutor;
    private final ExpirationAfterWriteStrategy expirationStrategy;

    public static RedissonBasedProxyManagerBuilder builderFor(CommandExecutor commandExecutor) {
        return new RedissonBasedProxyManagerBuilder(commandExecutor);
    }

    private RedissonBasedProxyManager(RedissonBasedProxyManagerBuilder builder) {
        super(builder.getClientSideConfig());
        this.commandExecutor = builder.commandExecutor;
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(final String key) {
        final List<String> keys = Collections.singletonList(key);
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData() {
                byte[] persistedState = (byte[])RedissonBasedProxyManager.this.commandExecutor.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
                return Optional.ofNullable(persistedState);
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                long ttlMillis = RedissonBasedProxyManager.this.calculateTtlMillis(newState);
                if (ttlMillis > 0L) {
                    if (originalData == null) {
                        RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(key, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{key, RedissonBasedProxyManager.this.encodeByteArray(newData), "PX", ttlMillis, "NX"});
                        return (Boolean)RedissonBasedProxyManager.this.commandExecutor.get(redissonFuture);
                    }
                    Object[] params = new Object[]{originalData, newData, ttlMillis};
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(key, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end", keys, params);
                    return (Boolean)RedissonBasedProxyManager.this.commandExecutor.get(redissonFuture);
                }
                if (originalData == null) {
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(key, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{key, RedissonBasedProxyManager.this.encodeByteArray(newData), "NX"});
                    return (Boolean)RedissonBasedProxyManager.this.commandExecutor.get(redissonFuture);
                }
                Object[] params = new Object[]{originalData, newData};
                RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(key, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end", keys, params);
                return (Boolean)RedissonBasedProxyManager.this.commandExecutor.get(redissonFuture);
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(final String key) {
        final List<String> keys = Collections.singletonList(key);
        return new AsyncCompareAndSwapOperation(){

            public CompletableFuture<Optional<byte[]>> getStateData() {
                RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.readAsync(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
                return RedissonBasedProxyManager.this.convertFuture(redissonFuture).thenApply(resultBytes -> Optional.ofNullable(resultBytes));
            }

            public CompletableFuture<Boolean> compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                long ttlMillis = RedissonBasedProxyManager.this.calculateTtlMillis(newState);
                if (ttlMillis > 0L) {
                    if (originalData == null) {
                        RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(key, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{key, RedissonBasedProxyManager.this.encodeByteArray(newData), "PX", ttlMillis, "NX"});
                        return RedissonBasedProxyManager.this.convertFuture(redissonFuture);
                    }
                    Object[] params = new Object[]{RedissonBasedProxyManager.this.encodeByteArray(originalData), RedissonBasedProxyManager.this.encodeByteArray(newData), ttlMillis};
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(key, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end", keys, params);
                    return RedissonBasedProxyManager.this.convertFuture(redissonFuture);
                }
                if (originalData == null) {
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(key, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{key, RedissonBasedProxyManager.this.encodeByteArray(newData), "NX"});
                    return RedissonBasedProxyManager.this.convertFuture(redissonFuture);
                }
                Object[] params = new Object[]{RedissonBasedProxyManager.this.encodeByteArray(originalData), RedissonBasedProxyManager.this.encodeByteArray(newData)};
                RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(key, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end", keys, params);
                return RedissonBasedProxyManager.this.convertFuture(redissonFuture);
            }
        };
    }

    public void removeProxy(String key) {
        RFuture future = this.commandExecutor.writeAsync(key, (RedisCommand)RedisCommands.DEL_VOID, new Object[]{key});
        this.commandExecutor.get(future);
    }

    protected CompletableFuture<Void> removeAsync(String key) {
        RFuture redissonFuture = this.commandExecutor.writeAsync(key, (RedisCommand)RedisCommands.DEL_VOID, new Object[]{key});
        return this.convertFuture(redissonFuture).thenApply(bytes -> null);
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    private <T> CompletableFuture<T> convertFuture(RFuture<T> redissonFuture) {
        CompletableFuture jdkFuture = new CompletableFuture();
        redissonFuture.whenComplete((result, error) -> {
            if (error != null) {
                jdkFuture.completeExceptionally((Throwable)error);
            } else {
                jdkFuture.complete(result);
            }
        });
        return jdkFuture;
    }

    public ByteBuf encodeByteArray(byte[] value) {
        try {
            return ByteArrayCodec.INSTANCE.getValueEncoder().encode((Object)value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private long calculateTtlMillis(RemoteBucketState state) {
        Optional clock = this.getClientSideConfig().getClientSideClock();
        long currentTimeNanos = clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
        return this.expirationStrategy.calculateTimeToLiveMillis(state, currentTimeNanos);
    }

    public static class RedissonBasedProxyManagerBuilder
    extends AbstractRedisProxyManagerBuilder<RedissonBasedProxyManagerBuilder> {
        private final CommandExecutor commandExecutor;

        private RedissonBasedProxyManagerBuilder(CommandExecutor commandExecutor) {
            this.commandExecutor = Objects.requireNonNull(commandExecutor);
        }

        public RedissonBasedProxyManager build() {
            return new RedissonBasedProxyManager(this);
        }
    }
}

