/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.lettuce.cas;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class LettuceBasedProxyManager
extends AbstractCompareAndSwapBasedProxyManager<byte[]> {
    private final RedisApi redisApi;
    private final ExpirationAfterWriteStrategy expirationStrategy;

    public static LettuceBasedProxyManagerBuilder builderFor(final RedisAsyncCommands<byte[], byte[]> redisAsyncCommands) {
        Objects.requireNonNull(redisAsyncCommands);
        RedisApi redisApi = new RedisApi(){

            @Override
            public <V> RedisFuture<V> eval(String script, ScriptOutputType scriptOutputType, byte[][] keys, byte[][] params) {
                return redisAsyncCommands.eval(script, scriptOutputType, (Object[])keys, (Object[])params);
            }

            @Override
            public RedisFuture<byte[]> get(byte[] key) {
                return redisAsyncCommands.get((Object)key);
            }

            @Override
            public RedisFuture<Void> delete(byte[] key) {
                return redisAsyncCommands.del((Object[])new byte[][]{key});
            }
        };
        return new LettuceBasedProxyManagerBuilder(redisApi);
    }

    public static LettuceBasedProxyManagerBuilder builderFor(StatefulRedisConnection<byte[], byte[]> statefulRedisConnection) {
        return LettuceBasedProxyManager.builderFor((RedisAsyncCommands<byte[], byte[]>)statefulRedisConnection.async());
    }

    public static LettuceBasedProxyManagerBuilder builderFor(RedisClient redisClient) {
        return LettuceBasedProxyManager.builderFor((StatefulRedisConnection<byte[], byte[]>)redisClient.connect((RedisCodec)ByteArrayCodec.INSTANCE));
    }

    public static LettuceBasedProxyManagerBuilder builderFor(RedisClusterClient redisClient) {
        return LettuceBasedProxyManager.builderFor((StatefulRedisClusterConnection<byte[], byte[]>)redisClient.connect((RedisCodec)ByteArrayCodec.INSTANCE));
    }

    public static LettuceBasedProxyManagerBuilder builderFor(StatefulRedisClusterConnection<byte[], byte[]> connection) {
        return LettuceBasedProxyManager.builderFor((RedisAdvancedClusterAsyncCommands<byte[], byte[]>)connection.async());
    }

    public static LettuceBasedProxyManagerBuilder builderFor(final RedisAdvancedClusterAsyncCommands<byte[], byte[]> redisAsyncCommands) {
        Objects.requireNonNull(redisAsyncCommands);
        RedisApi redisApi = new RedisApi(){

            @Override
            public <V> RedisFuture<V> eval(String script, ScriptOutputType scriptOutputType, byte[][] keys, byte[][] params) {
                return redisAsyncCommands.eval(script, scriptOutputType, (Object[])keys, (Object[])params);
            }

            @Override
            public RedisFuture<byte[]> get(byte[] key) {
                return redisAsyncCommands.get((Object)key);
            }

            @Override
            public RedisFuture<Void> delete(byte[] key) {
                return redisAsyncCommands.del((Object[])new byte[][]{key});
            }
        };
        return new LettuceBasedProxyManagerBuilder(redisApi);
    }

    private LettuceBasedProxyManager(LettuceBasedProxyManagerBuilder builder) {
        super(builder.getClientSideConfig());
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
        this.redisApi = builder.redisApi;
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(final byte[] key) {
        final byte[][] keys = new byte[][]{key};
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData() {
                RedisFuture<byte[]> stateFuture = LettuceBasedProxyManager.this.redisApi.get(key);
                return Optional.ofNullable(LettuceBasedProxyManager.this.getFutureValue(stateFuture));
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return LettuceBasedProxyManager.this.getFutureValue(LettuceBasedProxyManager.this.compareAndSwapFuture(key, keys, originalData, newData, newState));
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(final byte[] key) {
        final byte[][] keys = new byte[][]{key};
        return new AsyncCompareAndSwapOperation(){

            public CompletableFuture<Optional<byte[]>> getStateData() {
                RedisFuture<byte[]> stateFuture = LettuceBasedProxyManager.this.redisApi.get(key);
                return LettuceBasedProxyManager.this.convertToCompletableFuture(stateFuture).thenApply(resultBytes -> Optional.ofNullable(resultBytes));
            }

            public CompletableFuture<Boolean> compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return LettuceBasedProxyManager.this.convertToCompletableFuture(LettuceBasedProxyManager.this.compareAndSwapFuture(key, keys, originalData, newData, newState));
            }
        };
    }

    public void removeProxy(byte[] key) {
        RedisFuture<Void> future = this.redisApi.delete(key);
        this.getFutureValue(future);
    }

    protected CompletableFuture<Void> removeAsync(byte[] key) {
        RedisFuture<Void> future = this.redisApi.delete(key);
        return this.convertToCompletableFuture(future).thenApply(bytes -> null);
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    private RedisFuture<Boolean> compareAndSwapFuture(byte[] key, byte[][] keys, byte[] originalData, byte[] newData, RemoteBucketState newState) {
        long ttlMillis = this.calculateTtlMillis(newState);
        if (ttlMillis > 0L) {
            if (originalData == null) {
                byte[][] params = new byte[][]{newData, this.encodeLong(ttlMillis)};
                return this.redisApi.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx', 'px', ARGV[2]) then return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
            }
            byte[][] params = new byte[][]{originalData, newData, this.encodeLong(ttlMillis)};
            return this.redisApi.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
        }
        if (originalData == null) {
            byte[][] params = new byte[][]{newData};
            return this.redisApi.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx') then return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
        }
        byte[][] params = new byte[][]{originalData, newData};
        return this.redisApi.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
    }

    private <T> CompletableFuture<T> convertToCompletableFuture(RedisFuture<T> redissonFuture) {
        CompletableFuture jdkFuture = new CompletableFuture();
        redissonFuture.whenComplete((result, error) -> {
            if (error != null) {
                jdkFuture.completeExceptionally((Throwable)error);
            } else {
                jdkFuture.complete(result);
            }
        });
        return jdkFuture;
    }

    private <V> V getFutureValue(RedisFuture<V> value) {
        try {
            return (V)value.get();
        }
        catch (InterruptedException e) {
            value.cancel(true);
            Thread.currentThread().interrupt();
            throw new RedisException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof RedisException ? (RedisException)e.getCause() : new RedisException("Unexpected exception while processing command", e.getCause());
        }
    }

    private byte[] encodeLong(Long value) {
        return ("" + value).getBytes(StandardCharsets.UTF_8);
    }

    private long calculateTtlMillis(RemoteBucketState state) {
        Optional clock = this.getClientSideConfig().getClientSideClock();
        long currentTimeNanos = clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
        return this.expirationStrategy.calculateTimeToLiveMillis(state, currentTimeNanos);
    }

    private static interface RedisApi {
        public <V> RedisFuture<V> eval(String var1, ScriptOutputType var2, byte[][] var3, byte[][] var4);

        public RedisFuture<byte[]> get(byte[] var1);

        public RedisFuture<Void> delete(byte[] var1);
    }

    public static class LettuceBasedProxyManagerBuilder
    extends AbstractRedisProxyManagerBuilder<LettuceBasedProxyManagerBuilder> {
        private final RedisApi redisApi;

        private LettuceBasedProxyManagerBuilder(RedisApi redisApi) {
            this.redisApi = Objects.requireNonNull(redisApi);
        }

        public LettuceBasedProxyManager build() {
            return new LettuceBasedProxyManager(this);
        }
    }
}

