/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.lettuce.cas;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class LettuceBasedProxyManager<K>
extends AbstractCompareAndSwapBasedProxyManager<K> {
    private final RedisApi<K> redisApi;
    private final ExpirationAfterWriteStrategy expirationStrategy;

    public static <K> LettuceBasedProxyManagerBuilder<K> builderFor(final RedisAsyncCommands<K, byte[]> redisAsyncCommands) {
        Objects.requireNonNull(redisAsyncCommands);
        RedisApi redisApi = new RedisApi<K>(){

            @Override
            public <V> RedisFuture<V> eval(String script, ScriptOutputType scriptOutputType, K[] keys, byte[][] params) {
                return redisAsyncCommands.eval(script, scriptOutputType, (Object[])keys, (Object[])params);
            }

            @Override
            public RedisFuture<byte[]> get(K key) {
                return redisAsyncCommands.get(key);
            }

            @Override
            public RedisFuture<?> delete(K key) {
                return redisAsyncCommands.del(new Object[]{key});
            }
        };
        return new LettuceBasedProxyManagerBuilder(redisApi);
    }

    public static <K> LettuceBasedProxyManagerBuilder<K> builderFor(StatefulRedisConnection<K, byte[]> statefulRedisConnection) {
        return LettuceBasedProxyManager.builderFor(statefulRedisConnection.async());
    }

    public static LettuceBasedProxyManagerBuilder<byte[]> builderFor(RedisClient redisClient) {
        return LettuceBasedProxyManager.builderFor(redisClient.connect((RedisCodec)ByteArrayCodec.INSTANCE));
    }

    public static LettuceBasedProxyManagerBuilder<byte[]> builderFor(RedisClusterClient redisClient) {
        return LettuceBasedProxyManager.builderFor(redisClient.connect((RedisCodec)ByteArrayCodec.INSTANCE));
    }

    public static <K> LettuceBasedProxyManagerBuilder<K> builderFor(StatefulRedisClusterConnection<K, byte[]> connection) {
        return LettuceBasedProxyManager.builderFor(connection.async());
    }

    public static <K> LettuceBasedProxyManagerBuilder<K> builderFor(final RedisAdvancedClusterAsyncCommands<K, byte[]> redisAsyncCommands) {
        Objects.requireNonNull(redisAsyncCommands);
        RedisApi redisApi = new RedisApi<K>(){

            @Override
            public <V> RedisFuture<V> eval(String script, ScriptOutputType scriptOutputType, K[] keys, byte[][] params) {
                return redisAsyncCommands.eval(script, scriptOutputType, (Object[])keys, (Object[])params);
            }

            @Override
            public RedisFuture<byte[]> get(K key) {
                return redisAsyncCommands.get(key);
            }

            @Override
            public RedisFuture<?> delete(K key) {
                return redisAsyncCommands.del(new Object[]{key});
            }
        };
        return new LettuceBasedProxyManagerBuilder(redisApi);
    }

    private LettuceBasedProxyManager(LettuceBasedProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
        this.redisApi = builder.redisApi;
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(final K key) {
        final Object[] keys = new Object[]{key};
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData() {
                RedisFuture<byte[]> stateFuture = LettuceBasedProxyManager.this.redisApi.get(key);
                return Optional.ofNullable(LettuceBasedProxyManager.this.getFutureValue(stateFuture));
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return LettuceBasedProxyManager.this.getFutureValue(LettuceBasedProxyManager.this.compareAndSwapFuture(keys, originalData, newData, newState));
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(final K key) {
        final Object[] keys = new Object[]{key};
        return new AsyncCompareAndSwapOperation(){

            public CompletableFuture<Optional<byte[]>> getStateData() {
                RedisFuture<byte[]> stateFuture = LettuceBasedProxyManager.this.redisApi.get(key);
                return LettuceBasedProxyManager.this.convertToCompletableFuture(stateFuture).thenApply(Optional::ofNullable);
            }

            public CompletableFuture<Boolean> compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return LettuceBasedProxyManager.this.convertToCompletableFuture(LettuceBasedProxyManager.this.compareAndSwapFuture(keys, originalData, newData, newState));
            }
        };
    }

    public void removeProxy(K key) {
        RedisFuture<?> future = this.redisApi.delete(key);
        this.getFutureValue(future);
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        RedisFuture<?> future = this.redisApi.delete(key);
        return this.convertToCompletableFuture(future).thenApply(bytes -> null);
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    private RedisFuture<Boolean> compareAndSwapFuture(K[] keys, byte[] originalData, byte[] newData, RemoteBucketState newState) {
        long ttlMillis = this.calculateTtlMillis(newState);
        if (ttlMillis > 0L) {
            if (originalData == null) {
                byte[][] params = new byte[][]{newData, this.encodeLong(ttlMillis)};
                return this.redisApi.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx', 'px', ARGV[2]) then return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
            }
            byte[][] params = new byte[][]{originalData, newData, this.encodeLong(ttlMillis)};
            return this.redisApi.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
        }
        if (originalData == null) {
            byte[][] params = new byte[][]{newData};
            return this.redisApi.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx') then return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
        }
        byte[][] params = new byte[][]{originalData, newData};
        return this.redisApi.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end", ScriptOutputType.BOOLEAN, keys, params);
    }

    private <T> CompletableFuture<T> convertToCompletableFuture(RedisFuture<T> redissonFuture) {
        CompletableFuture jdkFuture = new CompletableFuture();
        redissonFuture.whenComplete((result, error) -> {
            if (error != null) {
                jdkFuture.completeExceptionally((Throwable)error);
            } else {
                jdkFuture.complete(result);
            }
        });
        return jdkFuture;
    }

    private <V> V getFutureValue(RedisFuture<V> value) {
        try {
            return (V)value.get();
        }
        catch (InterruptedException e) {
            value.cancel(true);
            Thread.currentThread().interrupt();
            throw new RedisException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof RedisException ? (RedisException)e.getCause() : new RedisException("Unexpected exception while processing command", e.getCause());
        }
    }

    private byte[] encodeLong(Long value) {
        return ("" + value).getBytes(StandardCharsets.UTF_8);
    }

    private long calculateTtlMillis(RemoteBucketState state) {
        Optional clock = this.getClientSideConfig().getClientSideClock();
        long currentTimeNanos = clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
        return this.expirationStrategy.calculateTimeToLiveMillis(state, currentTimeNanos);
    }

    private static interface RedisApi<K> {
        public <V> RedisFuture<V> eval(String var1, ScriptOutputType var2, K[] var3, byte[][] var4);

        public RedisFuture<byte[]> get(K var1);

        public RedisFuture<?> delete(K var1);
    }

    public static class LettuceBasedProxyManagerBuilder<K>
    extends AbstractRedisProxyManagerBuilder<LettuceBasedProxyManagerBuilder<K>> {
        private final RedisApi<K> redisApi;

        private LettuceBasedProxyManagerBuilder(RedisApi<K> redisApi) {
            this.redisApi = Objects.requireNonNull(redisApi);
        }

        public LettuceBasedProxyManager<K> build() {
            return new LettuceBasedProxyManager(this);
        }
    }
}

