/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.TypedStreamDeserializer;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.grid.hazelcast.VersionedBackupProcessor;
import io.github.bucket4j.grid.hazelcast.serialization.SerializationUtilities;
import java.io.IOException;

public class VersionedBackupProcessorSerializer
implements StreamSerializer<VersionedBackupProcessor>,
TypedStreamDeserializer<VersionedBackupProcessor> {
    private final int typeId;

    public VersionedBackupProcessorSerializer(int typeId) {
        this.typeId = typeId;
    }

    public VersionedBackupProcessorSerializer() {
        this.typeId = SerializationUtilities.getSerializerTypeId(this.getClass());
    }

    public Class<VersionedBackupProcessor> getSerializableType() {
        return VersionedBackupProcessor.class;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void write(ObjectDataOutput out, VersionedBackupProcessor serializable) throws IOException {
        out.writeInt(Versions.v_8_10_0.getNumber());
        out.writeByteArray(serializable.getState());
        if (serializable.getTtlMillis() != null) {
            out.writeBoolean(true);
            out.writeLong(serializable.getTtlMillis().longValue());
        } else {
            out.writeBoolean(false);
        }
    }

    public VersionedBackupProcessor read(ObjectDataInput in) throws IOException {
        return this.read0(in);
    }

    public VersionedBackupProcessor read(ObjectDataInput in, Class aClass) throws IOException {
        return this.read0(in);
    }

    private VersionedBackupProcessor read0(ObjectDataInput in) throws IOException {
        int version = in.readInt();
        Versions.check((int)version, (Version)Versions.v_8_10_0, (Version)Versions.v_8_10_0);
        byte[] state = in.readByteArray();
        Long ttlMillis = in.readBoolean() ? Long.valueOf(in.readLong()) : null;
        return new VersionedBackupProcessor(state, ttlMillis);
    }
}

