/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.ignite.thin.cas;

import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.grid.ignite.thin.Bucket4jIgniteThin;
import io.github.bucket4j.grid.ignite.thin.ThinClientUtils;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.IgniteClientFuture;

public class IgniteThinClientCasBasedProxyManager<K>
extends AbstractCompareAndSwapBasedProxyManager<K> {
    private final ClientCache<K, ByteBuffer> cache;

    public IgniteThinClientCasBasedProxyManager(Bucket4jIgniteThin.IgniteThinClientCasBasedProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.cache = builder.getCache();
    }

    @Deprecated
    public IgniteThinClientCasBasedProxyManager(ClientCache<K, ByteBuffer> cache) {
        this(cache, ClientSideConfig.getDefault());
    }

    @Deprecated
    public IgniteThinClientCasBasedProxyManager(ClientCache<K, ByteBuffer> cache, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.cache = Objects.requireNonNull(cache);
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(final K key) {
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData(Optional<Long> timeoutNanos) {
                ByteBuffer persistedState = (ByteBuffer)IgniteThinClientCasBasedProxyManager.this.cache.get(key);
                if (persistedState == null) {
                    return Optional.empty();
                }
                byte[] persistedStateBytes = persistedState.array();
                return Optional.of(persistedStateBytes);
            }

            public boolean compareAndSwap(byte[] originalDataBytes, byte[] newDataBytes, RemoteBucketState newState, Optional<Long> timeoutNanos) {
                ByteBuffer newData = ByteBuffer.wrap(newDataBytes);
                if (originalDataBytes == null) {
                    return IgniteThinClientCasBasedProxyManager.this.cache.putIfAbsent(key, (Object)newData);
                }
                ByteBuffer originalData = ByteBuffer.wrap(originalDataBytes);
                return IgniteThinClientCasBasedProxyManager.this.cache.replace(key, (Object)originalData, (Object)newData);
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(final K key) {
        return new AsyncCompareAndSwapOperation(){

            public CompletableFuture<Optional<byte[]>> getStateData(Optional<Long> timeoutNanos) {
                IgniteClientFuture igniteFuture = IgniteThinClientCasBasedProxyManager.this.cache.getAsync(key);
                CompletableFuture resultFuture = ThinClientUtils.convertFuture(igniteFuture);
                return resultFuture.thenApply(persistedState -> {
                    if (persistedState == null) {
                        return Optional.empty();
                    }
                    byte[] persistedStateBytes = persistedState.array();
                    return Optional.of(persistedStateBytes);
                });
            }

            public CompletableFuture<Boolean> compareAndSwap(byte[] originalDataBytes, byte[] newDataBytes, RemoteBucketState newState, Optional<Long> timeoutNanos) {
                ByteBuffer newData = ByteBuffer.wrap(newDataBytes);
                if (originalDataBytes == null) {
                    IgniteClientFuture igniteFuture = IgniteThinClientCasBasedProxyManager.this.cache.putIfAbsentAsync(key, (Object)newData);
                    return ThinClientUtils.convertFuture(igniteFuture);
                }
                ByteBuffer originalData = ByteBuffer.wrap(originalDataBytes);
                IgniteClientFuture igniteFuture = IgniteThinClientCasBasedProxyManager.this.cache.replaceAsync(key, (Object)originalData, (Object)newData);
                return ThinClientUtils.convertFuture(igniteFuture);
            }
        };
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    public void removeProxy(K key) {
        this.cache.remove(key);
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        IgniteClientFuture igniteFuture = this.cache.removeAsync(key);
        return ThinClientUtils.convertFuture(igniteFuture).thenApply(result -> null);
    }
}

