/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.ignite.thin.compute;

import io.github.bucket4j.grid.ignite.thin.compute.Bucket4jComputeJob;
import io.github.bucket4j.grid.ignite.thin.compute.Bucket4jComputeTaskParams;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.resources.IgniteInstanceResource;

public class Bucket4jComputeTask<K>
extends ComputeTaskAdapter<Bucket4jComputeTaskParams<K>, byte[]> {
    public static final String JOB_NAME = Bucket4jComputeTask.class.getName();
    @IgniteInstanceResource
    private Ignite ignite;

    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, Bucket4jComputeTaskParams<K> params) throws IgniteException {
        Bucket4jComputeJob<K> job = new Bucket4jComputeJob<K>(params);
        ClusterNode primaryNodeForKey = this.ignite.affinity(params.getCacheName()).mapKeyToNode(params.getKey());
        for (ClusterNode clusterNode : subgrid) {
            if (clusterNode != primaryNodeForKey) continue;
            return Collections.singletonMap(job, clusterNode);
        }
        int randomNode = ThreadLocalRandom.current().nextInt(subgrid.size());
        return Collections.singletonMap(job, subgrid.get(randomNode));
    }

    public byte[] reduce(List<ComputeJobResult> results) throws IgniteException {
        return (byte[])results.get(0).getData();
    }
}

