/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.jedis;

import io.github.bucket4j.distributed.proxy.AbstractProxyManagerBuilder;
import io.github.bucket4j.distributed.serialization.Mapper;
import io.github.bucket4j.redis.jedis.RedisApi;
import io.github.bucket4j.redis.jedis.cas.JedisBasedProxyManager;
import java.util.Objects;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.util.Pool;

public class Bucket4jJedis {
    public static JedisBasedProxyManagerBuilder<byte[]> casBasedBuilder(final Pool<Jedis> jedisPool) {
        Objects.requireNonNull(jedisPool);
        RedisApi redisApi = new RedisApi(){

            @Override
            public Object eval(byte[] script, int keyCount, byte[] ... params) {
                try (Jedis jedis = (Jedis)jedisPool.getResource();){
                    Object object = jedis.eval(script, 1, params);
                    return object;
                }
            }

            @Override
            public byte[] get(byte[] key) {
                try (Jedis jedis = (Jedis)jedisPool.getResource();){
                    byte[] byArray = jedis.get(key);
                    return byArray;
                }
            }

            @Override
            public void delete(byte[] key) {
                try (Jedis jedis = (Jedis)jedisPool.getResource();){
                    jedis.del(key);
                }
            }
        };
        return new JedisBasedProxyManagerBuilder<byte[]>(Mapper.BYTES, redisApi);
    }

    public static JedisBasedProxyManagerBuilder<byte[]> casBasedBuilder(final UnifiedJedis unifiedJedis) {
        Objects.requireNonNull(unifiedJedis);
        RedisApi redisApi = new RedisApi(){

            @Override
            public Object eval(byte[] script, int keyCount, byte[] ... params) {
                return unifiedJedis.eval(script, keyCount, params);
            }

            @Override
            public byte[] get(byte[] key) {
                return unifiedJedis.get(key);
            }

            @Override
            public void delete(byte[] key) {
                unifiedJedis.del(key);
            }
        };
        return new JedisBasedProxyManagerBuilder<byte[]>(Mapper.BYTES, redisApi);
    }

    public static JedisBasedProxyManagerBuilder<byte[]> casBasedBuilder(final JedisCluster jedisCluster) {
        Objects.requireNonNull(jedisCluster);
        RedisApi redisApi = new RedisApi(){

            @Override
            public Object eval(byte[] script, int keyCount, byte[] ... params) {
                return jedisCluster.eval(script, keyCount, params);
            }

            @Override
            public byte[] get(byte[] key) {
                return jedisCluster.get(key);
            }

            @Override
            public void delete(byte[] key) {
                jedisCluster.del(key);
            }
        };
        return new JedisBasedProxyManagerBuilder<byte[]>(Mapper.BYTES, redisApi);
    }

    public static class JedisBasedProxyManagerBuilder<K>
    extends AbstractProxyManagerBuilder<K, JedisBasedProxyManager<K>, JedisBasedProxyManagerBuilder<K>> {
        final RedisApi redisApi;
        Mapper<K> keyMapper;

        public JedisBasedProxyManagerBuilder(Mapper<K> keyMapper, RedisApi redisApi) {
            this.redisApi = redisApi;
            this.keyMapper = Objects.requireNonNull(keyMapper);
        }

        public JedisBasedProxyManager<K> build() {
            return new JedisBasedProxyManager(this);
        }

        public <K2> JedisBasedProxyManagerBuilder<K2> keyMapper(Mapper<K2> keyMapper) {
            this.keyMapper = Objects.requireNonNull(keyMapper);
            return this;
        }

        public Mapper<K> getKeyMapper() {
            return this.keyMapper;
        }

        public RedisApi getRedisApi() {
            return this.redisApi;
        }

        public boolean isExpireAfterWriteSupported() {
            return true;
        }
    }
}

