/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.lettuce;

import io.github.bucket4j.distributed.proxy.AbstractProxyManagerBuilder;
import io.github.bucket4j.redis.lettuce.RedisApi;
import io.github.bucket4j.redis.lettuce.cas.LettuceBasedProxyManager;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.util.Objects;

public class Bucket4jLettuce {
    public static <K> LettuceBasedProxyManagerBuilder<K> casBasedBuilder(final RedisAsyncCommands<K, byte[]> redisAsyncCommands) {
        Objects.requireNonNull(redisAsyncCommands);
        RedisApi redisApi = new RedisApi<K>(){

            @Override
            public <V> RedisFuture<V> eval(String script, ScriptOutputType scriptOutputType, K[] keys, byte[][] params) {
                return redisAsyncCommands.eval(script, scriptOutputType, (Object[])keys, (Object[])params);
            }

            @Override
            public RedisFuture<byte[]> get(K key) {
                return redisAsyncCommands.get(key);
            }

            @Override
            public RedisFuture<?> delete(K key) {
                return redisAsyncCommands.del(new Object[]{key});
            }
        };
        return new LettuceBasedProxyManagerBuilder(redisApi);
    }

    public static <K> LettuceBasedProxyManagerBuilder<K> casBasedBuilder(StatefulRedisConnection<K, byte[]> statefulRedisConnection) {
        return Bucket4jLettuce.casBasedBuilder(statefulRedisConnection.async());
    }

    public static LettuceBasedProxyManagerBuilder<byte[]> casBasedBuilder(RedisClient redisClient) {
        return Bucket4jLettuce.casBasedBuilder(redisClient.connect((RedisCodec)ByteArrayCodec.INSTANCE));
    }

    public static LettuceBasedProxyManagerBuilder<byte[]> casBasedBuilder(RedisClusterClient redisClient) {
        return Bucket4jLettuce.casBasedBuilder(redisClient.connect((RedisCodec)ByteArrayCodec.INSTANCE));
    }

    public static <K> LettuceBasedProxyManagerBuilder<K> casBasedBuilder(StatefulRedisClusterConnection<K, byte[]> connection) {
        return Bucket4jLettuce.casBasedBuilder(connection.async());
    }

    public static <K> LettuceBasedProxyManagerBuilder<K> casBasedBuilder(final RedisAdvancedClusterAsyncCommands<K, byte[]> redisAsyncCommands) {
        Objects.requireNonNull(redisAsyncCommands);
        RedisApi redisApi = new RedisApi<K>(){

            @Override
            public <V> RedisFuture<V> eval(String script, ScriptOutputType scriptOutputType, K[] keys, byte[][] params) {
                return redisAsyncCommands.eval(script, scriptOutputType, (Object[])keys, (Object[])params);
            }

            @Override
            public RedisFuture<byte[]> get(K key) {
                return redisAsyncCommands.get(key);
            }

            @Override
            public RedisFuture<?> delete(K key) {
                return redisAsyncCommands.del(new Object[]{key});
            }
        };
        return new LettuceBasedProxyManagerBuilder(redisApi);
    }

    public static class LettuceBasedProxyManagerBuilder<K>
    extends AbstractProxyManagerBuilder<K, LettuceBasedProxyManager<K>, LettuceBasedProxyManagerBuilder<K>> {
        private final RedisApi<K> redisApi;

        public LettuceBasedProxyManagerBuilder(RedisApi<K> redisApi) {
            this.redisApi = redisApi;
        }

        public RedisApi<K> getRedisApi() {
            return this.redisApi;
        }

        public LettuceBasedProxyManager<K> build() {
            return new LettuceBasedProxyManager(this);
        }

        public boolean isExpireAfterWriteSupported() {
            return true;
        }
    }
}

