/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.postgresql;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.jdbc.CustomColumnProvider;
import io.github.bucket4j.distributed.jdbc.LockIdSupplier;
import io.github.bucket4j.distributed.jdbc.PrimaryKeyMapper;
import io.github.bucket4j.distributed.jdbc.SQLProxyConfiguration;
import io.github.bucket4j.distributed.proxy.ExpiredEntriesCleaner;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.AbstractLockBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.LockBasedTransaction;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.postgresql.Bucket4jPostgreSQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;

public class PostgreSQLadvisoryLockBasedProxyManager<K>
extends AbstractLockBasedProxyManager<K>
implements ExpiredEntriesCleaner {
    private final LockIdSupplier<K> lockIdSupplier;
    private final PrimaryKeyMapper<K> primaryKeyMapper;
    private final DataSource dataSource;
    private final String removeSqlQuery;
    private final String updateSqlQuery;
    private final String insertSqlQuery;
    private final String selectSqlQuery;
    private final String clearExpiredSqlQuery;
    private final List<CustomColumnProvider<K>> customColumns = new ArrayList<CustomColumnProvider<K>>();

    PostgreSQLadvisoryLockBasedProxyManager(Bucket4jPostgreSQL.PostgreSQLAdvisoryLockBasedProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.dataSource = builder.getDataSource();
        this.primaryKeyMapper = builder.getPrimaryKeyMapper();
        this.lockIdSupplier = builder.getLockIdSupplier();
        this.removeSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", builder.getTableName(), builder.getIdColumnName());
        this.selectSqlQuery = MessageFormat.format("SELECT {0} as state FROM {1} WHERE {2} = ?", builder.getStateColumnName(), builder.getTableName(), builder.getIdColumnName());
        this.customColumns.addAll(builder.getCustomColumns());
        this.getClientSideConfig().getExpirationAfterWriteStrategy().ifPresent(expiration -> {
            this.customColumns.add(CustomColumnProvider.createExpiresInColumnProvider((String)builder.getExpiresAtColumnName(), (ExpirationAfterWriteStrategy)expiration));
            final String lockColumn = builder.getLockColumn();
            this.customColumns.add(new CustomColumnProvider<K>(){

                public void setCustomField(K key, int paramIndex, PreparedStatement statement, RemoteBucketState state, long currentTimeNanos) throws SQLException {
                    statement.setLong(paramIndex, PostgreSQLadvisoryLockBasedProxyManager.this.lockIdSupplier.toLockId(key));
                }

                public String getCustomFieldName() {
                    return lockColumn;
                }
            });
        });
        if (this.customColumns.isEmpty()) {
            this.insertSqlQuery = MessageFormat.format("INSERT INTO {0}({1}, {2}) VALUES(?, ?)", builder.getTableName(), builder.getIdColumnName(), builder.getStateColumnName());
            this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=? WHERE {2}=?", builder.getTableName(), builder.getStateColumnName(), builder.getIdColumnName());
        } else {
            String customPartInUpdate = String.join((CharSequence)",", this.customColumns.stream().map(column -> column.getCustomFieldName() + "=?").toList());
            this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=?,{2} WHERE {3}=?", builder.getTableName(), builder.getStateColumnName(), customPartInUpdate, builder.getIdColumnName());
            String customInsertColumns = String.join((CharSequence)",", this.customColumns.stream().map(CustomColumnProvider::getCustomFieldName).toList());
            String customInsertValues = String.join((CharSequence)",", this.customColumns.stream().map(column -> "?").toList());
            this.insertSqlQuery = MessageFormat.format("INSERT INTO {0}({1},{2},{3}) VALUES(?,?,{4})", builder.getTableName(), builder.getIdColumnName(), builder.getStateColumnName(), customInsertColumns, customInsertValues);
        }
        this.clearExpiredSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE\n    {2} < ? AND\n    {1} IN(SELECT {1} FROM {0} WHERE {2} < ? AND pg_try_advisory_xact_lock({3}) LIMIT ?)\n", builder.getTableName(), builder.getIdColumnName(), builder.getExpiresAtColumnName(), builder.getLockColumn());
    }

    @Deprecated
    public PostgreSQLadvisoryLockBasedProxyManager(SQLProxyConfiguration<K> configuration) {
        super(configuration.getClientSideConfig());
        this.clearExpiredSqlQuery = null;
        this.dataSource = Objects.requireNonNull(configuration.getDataSource());
        this.primaryKeyMapper = configuration.getPrimaryKeyMapper();
        this.lockIdSupplier = LockIdSupplier.DEFAULT;
        this.removeSqlQuery = MessageFormat.format("DELETE FROM {0} WHERE {1} = ?", configuration.getTableName(), configuration.getIdName());
        this.updateSqlQuery = MessageFormat.format("UPDATE {0} SET {1}=? WHERE {2}=?", configuration.getTableName(), configuration.getStateName(), configuration.getIdName());
        this.insertSqlQuery = MessageFormat.format("INSERT INTO {0}({1}, {2}) VALUES(?, ?)", configuration.getTableName(), configuration.getIdName(), configuration.getStateName());
        this.selectSqlQuery = MessageFormat.format("SELECT {0} as state FROM {1} WHERE {2} = ?", configuration.getStateName(), configuration.getTableName(), configuration.getIdName());
        if (this.getClientSideConfig().getExpirationAfterWriteStrategy().isPresent()) {
            throw new IllegalArgumentException();
        }
    }

    protected LockBasedTransaction allocateTransaction(final K key, Optional<Long> requestTimeout) {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
        return new LockBasedTransaction(){

            public void begin(Optional<Long> requestTimeout) {
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public byte[] lockAndGet(Optional<Long> requestTimeout) {
                try {
                    String lockSQL = "SELECT pg_advisory_xact_lock(?)";
                    try (PreparedStatement lockStatement = connection.prepareStatement(lockSQL);){
                        PostgreSQLadvisoryLockBasedProxyManager.this.applyTimeout(lockStatement, requestTimeout);
                        long advisoryLockValue = PostgreSQLadvisoryLockBasedProxyManager.this.lockIdSupplier.toLockId(key);
                        lockStatement.setLong(1, advisoryLockValue);
                        lockStatement.executeQuery();
                    }
                    try (PreparedStatement selectStatement = connection.prepareStatement(PostgreSQLadvisoryLockBasedProxyManager.this.selectSqlQuery);){
                        byte[] byArray;
                        block25: {
                            ResultSet rs;
                            block23: {
                                byte[] byArray2;
                                block24: {
                                    PostgreSQLadvisoryLockBasedProxyManager.this.primaryKeyMapper.set(selectStatement, 1, key);
                                    rs = selectStatement.executeQuery();
                                    try {
                                        if (!rs.next()) break block23;
                                        byArray2 = rs.getBytes("state");
                                        if (rs == null) break block24;
                                    }
                                    catch (Throwable throwable) {
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    rs.close();
                                }
                                return byArray2;
                            }
                            byArray = null;
                            if (rs == null) break block25;
                            rs.close();
                        }
                        return byArray;
                    }
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void update(byte[] data, RemoteBucketState newState, Optional<Long> requestTimeout) {
                try (PreparedStatement updateStatement = connection.prepareStatement(PostgreSQLadvisoryLockBasedProxyManager.this.updateSqlQuery);){
                    PostgreSQLadvisoryLockBasedProxyManager.this.applyTimeout(updateStatement, requestTimeout);
                    int i = 0;
                    updateStatement.setBytes(++i, data);
                    for (CustomColumnProvider column : PostgreSQLadvisoryLockBasedProxyManager.this.customColumns) {
                        column.setCustomField(key, ++i, updateStatement, newState, PostgreSQLadvisoryLockBasedProxyManager.this.currentTimeNanos());
                    }
                    PostgreSQLadvisoryLockBasedProxyManager.this.primaryKeyMapper.set(updateStatement, ++i, key);
                    updateStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void release() {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void create(byte[] data, RemoteBucketState newState, Optional<Long> requestTimeout) {
                try (PreparedStatement insertStatement = connection.prepareStatement(PostgreSQLadvisoryLockBasedProxyManager.this.insertSqlQuery);){
                    PostgreSQLadvisoryLockBasedProxyManager.this.applyTimeout(insertStatement, requestTimeout);
                    int i = 0;
                    PostgreSQLadvisoryLockBasedProxyManager.this.primaryKeyMapper.set(insertStatement, ++i, key);
                    insertStatement.setBytes(++i, data);
                    for (CustomColumnProvider column : PostgreSQLadvisoryLockBasedProxyManager.this.customColumns) {
                        column.setCustomField(key, ++i, insertStatement, newState, PostgreSQLadvisoryLockBasedProxyManager.this.currentTimeNanos());
                    }
                    insertStatement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void rollback() {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void commit(Optional<Long> requestTimeout) {
                try {
                    connection.commit();
                }
                catch (SQLException e) {
                    throw new BucketExceptions.BucketExecutionException((Throwable)e);
                }
            }

            public void unlock() {
            }
        };
    }

    public void removeProxy(K key) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement removeStatement = connection.prepareStatement(this.removeSqlQuery);){
            this.primaryKeyMapper.set(removeStatement, 1, key);
            removeStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
    }

    public boolean isExpireAfterWriteSupported() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int removeExpired(int batchSize) {
        try (Connection connection = this.dataSource.getConnection();){
            int n;
            block14: {
                long currentTimeMillis = System.currentTimeMillis();
                PreparedStatement clearStatement = connection.prepareStatement(this.clearExpiredSqlQuery);
                try {
                    clearStatement.setLong(1, currentTimeMillis);
                    clearStatement.setLong(2, currentTimeMillis);
                    clearStatement.setInt(3, batchSize);
                    n = clearStatement.executeUpdate();
                    if (clearStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (clearStatement != null) {
                        try {
                            clearStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                clearStatement.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new BucketExceptions.BucketExecutionException((Throwable)e);
        }
    }
}

