/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.redisson.cas;

import io.github.bucket4j.TimeoutException;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.serialization.Mapper;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import io.github.bucket4j.redis.redisson.Bucket4jRedisson;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisException;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanNotNullReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonBasedProxyManager<K>
extends AbstractCompareAndSwapBasedProxyManager<K> {
    public static final RedisCommand<Boolean> SET = new RedisCommand("SET", (Convertor)new BooleanNotNullReplayConvertor());
    private final CommandAsyncExecutor commandExecutor;
    private final ExpirationAfterWriteStrategy expirationStrategy;
    private final Mapper<K> keyMapper;

    @Deprecated
    public static RedissonBasedProxyManagerBuilder<String> builderFor(CommandAsyncExecutor commandExecutor) {
        return new RedissonBasedProxyManagerBuilder<String>(Mapper.STRING, commandExecutor);
    }

    public RedissonBasedProxyManager(Bucket4jRedisson.RedissonBasedProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.commandExecutor = builder.getCommandExecutor();
        this.expirationStrategy = builder.getExpirationAfterWrite().orElse(ExpirationAfterWriteStrategy.none());
        this.keyMapper = builder.getKeyMapper();
    }

    private RedissonBasedProxyManager(RedissonBasedProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.commandExecutor = builder.commandExecutor;
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
        this.keyMapper = builder.keyMapper;
    }

    public boolean isExpireAfterWriteSupported() {
        return true;
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(K key) {
        final String stringKey = this.keyMapper.toString(key);
        final List<String> keys = Collections.singletonList(stringKey);
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData(Optional<Long> timeoutNanos) {
                RFuture persistedState = RedissonBasedProxyManager.this.commandExecutor.readAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{stringKey});
                return Optional.ofNullable((byte[])RedissonBasedProxyManager.this.getWithTimeout(persistedState, timeoutNanos));
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState, Optional<Long> timeoutNanos) {
                long ttlMillis = RedissonBasedProxyManager.this.expirationStrategy.calculateTimeToLiveMillis(newState, RedissonBasedProxyManager.this.currentTimeNanos());
                if (ttlMillis > 0L) {
                    if (originalData == null) {
                        RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{stringKey, RedissonBasedProxyManager.this.encodeByteArray(newData), "PX", ttlMillis, "NX"});
                        return (Boolean)RedissonBasedProxyManager.this.getWithTimeout(redissonFuture, timeoutNanos);
                    }
                    Object[] params = new Object[]{originalData, newData, ttlMillis};
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end", keys, params);
                    return (Boolean)RedissonBasedProxyManager.this.getWithTimeout(redissonFuture, timeoutNanos);
                }
                if (originalData == null) {
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{stringKey, RedissonBasedProxyManager.this.encodeByteArray(newData), "NX"});
                    return (Boolean)RedissonBasedProxyManager.this.getWithTimeout(redissonFuture, timeoutNanos);
                }
                Object[] params = new Object[]{originalData, newData};
                RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end", keys, params);
                return (Boolean)RedissonBasedProxyManager.this.getWithTimeout(redissonFuture, timeoutNanos);
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(K key) {
        final String stringKey = this.keyMapper.toString(key);
        final List<String> keys = Collections.singletonList(stringKey);
        return new AsyncCompareAndSwapOperation(){

            public CompletableFuture<Optional<byte[]>> getStateData(Optional<Long> timeoutNanos) {
                RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.readAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{stringKey});
                if (timeoutNanos.isEmpty()) {
                    return RedissonBasedProxyManager.this.convertFuture(redissonFuture, timeoutNanos).thenApply(resultBytes -> Optional.ofNullable(resultBytes));
                }
                return RedissonBasedProxyManager.this.convertFuture(redissonFuture, timeoutNanos).thenApply(resultBytes -> Optional.ofNullable(resultBytes));
            }

            public CompletableFuture<Boolean> compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState, Optional<Long> timeoutNanos) {
                long ttlMillis = RedissonBasedProxyManager.this.expirationStrategy.calculateTimeToLiveMillis(newState, RedissonBasedProxyManager.this.currentTimeNanos());
                if (ttlMillis > 0L) {
                    if (originalData == null) {
                        RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{stringKey, RedissonBasedProxyManager.this.encodeByteArray(newData), "PX", ttlMillis, "NX"});
                        return RedissonBasedProxyManager.this.convertFuture(redissonFuture, timeoutNanos);
                    }
                    Object[] params = new Object[]{RedissonBasedProxyManager.this.encodeByteArray(originalData), RedissonBasedProxyManager.this.encodeByteArray(newData), ttlMillis};
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end", keys, params);
                    return RedissonBasedProxyManager.this.convertFuture(redissonFuture, timeoutNanos);
                }
                if (originalData == null) {
                    RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.writeAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, SET, new Object[]{stringKey, RedissonBasedProxyManager.this.encodeByteArray(newData), "NX"});
                    return RedissonBasedProxyManager.this.convertFuture(redissonFuture, timeoutNanos);
                }
                Object[] params = new Object[]{RedissonBasedProxyManager.this.encodeByteArray(originalData), RedissonBasedProxyManager.this.encodeByteArray(newData)};
                RFuture redissonFuture = RedissonBasedProxyManager.this.commandExecutor.evalWriteAsync(stringKey, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end", keys, params);
                return RedissonBasedProxyManager.this.convertFuture(redissonFuture, timeoutNanos);
            }
        };
    }

    public void removeProxy(K key) {
        RFuture future = this.commandExecutor.writeAsync(this.keyMapper.toString(key), (RedisCommand)RedisCommands.DEL_VOID, new Object[]{key});
        this.commandExecutor.get(future);
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        RFuture redissonFuture = this.commandExecutor.writeAsync(this.keyMapper.toString(key), (RedisCommand)RedisCommands.DEL_VOID, new Object[]{key});
        return this.convertFuture(redissonFuture, Optional.empty()).thenApply(bytes -> null);
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    private <T> CompletableFuture<T> convertFuture(RFuture<T> redissonFuture, Optional<Long> timeoutNanos) {
        if (timeoutNanos.isEmpty()) {
            return redissonFuture.toCompletableFuture();
        }
        return redissonFuture.toCompletableFuture().orTimeout(timeoutNanos.get(), TimeUnit.NANOSECONDS);
    }

    private <T> T getWithTimeout(RFuture<T> redissonFuture, Optional<Long> timeoutNanos) {
        if (timeoutNanos.isEmpty()) {
            return (T)this.commandExecutor.get(redissonFuture);
        }
        try {
            return (T)redissonFuture.get(timeoutNanos.get().longValue(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            redissonFuture.cancel(true);
            Thread.currentThread().interrupt();
            throw new RedisException((Throwable)e);
        }
        catch (java.util.concurrent.TimeoutException e) {
            String message = "Violated timeout while waiting for redis future for " + timeoutNanos.get() + "ns";
            throw new TimeoutException(message, timeoutNanos.get().longValue(), timeoutNanos.get().longValue());
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RedisException) {
                RedisException re = (RedisException)throwable;
                throw re;
            }
            throw new RedisException((Throwable)e);
        }
    }

    public ByteBuf encodeByteArray(byte[] value) {
        try {
            return ByteArrayCodec.INSTANCE.getValueEncoder().encode((Object)value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class RedissonBasedProxyManagerBuilder<K>
    extends AbstractRedisProxyManagerBuilder<RedissonBasedProxyManagerBuilder<K>> {
        private final CommandAsyncExecutor commandExecutor;
        private Mapper<K> keyMapper;

        private RedissonBasedProxyManagerBuilder(Mapper<K> keyMapper, CommandAsyncExecutor commandExecutor) {
            this.keyMapper = Objects.requireNonNull(keyMapper);
            this.commandExecutor = Objects.requireNonNull(commandExecutor);
        }

        public <Key> RedissonBasedProxyManagerBuilder<Key> withKeyMapper(Mapper<Key> keyMapper) {
            this.keyMapper = Objects.requireNonNull(keyMapper);
            return this;
        }

        public RedissonBasedProxyManager<K> build() {
            return new RedissonBasedProxyManager(this);
        }
    }
}

