/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.infinispan;

import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.grid.infinispan.InfinispanProcessor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.FunctionalMap;

public class InfinispanProxyManager<K>
extends AbstractProxyManager<K> {
    private final InfinispanProcessor<K, Void> REMOVE_BUCKET_ENTRY_PROCESSOR = new InfinispanProcessor(new byte[0]);
    private final FunctionalMap.ReadWriteMap<K, byte[]> readWriteMap;

    public InfinispanProxyManager(FunctionalMap.ReadWriteMap<K, byte[]> readWriteMap) {
        this(readWriteMap, ClientSideConfig.getDefault());
    }

    public InfinispanProxyManager(FunctionalMap.ReadWriteMap<K, byte[]> readWriteMap, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.readWriteMap = Objects.requireNonNull(readWriteMap);
    }

    public <T> CommandResult<T> execute(K key, Request<T> request) {
        InfinispanProcessor entryProcessor = new InfinispanProcessor(request);
        try {
            CompletableFuture resultFuture = this.readWriteMap.eval(key, entryProcessor);
            return (CommandResult)((CompletableFuture)resultFuture.thenApply(resultBytes -> InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)request.getBackwardCompatibilityVersion()))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    public void removeProxy(K key) {
        try {
            this.removeAsync(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        try {
            CompletableFuture resultFuture = this.readWriteMap.eval(key, this.REMOVE_BUCKET_ENTRY_PROCESSOR);
            return resultFuture.thenApply(resultBytes -> null);
        }
        catch (Throwable t) {
            CompletableFuture<Void> fail = new CompletableFuture<Void>();
            fail.completeExceptionally(t);
            return fail;
        }
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        try {
            InfinispanProcessor entryProcessor = new InfinispanProcessor(request);
            CompletableFuture resultFuture = this.readWriteMap.eval(key, entryProcessor);
            return resultFuture.thenApply(resultBytes -> InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)request.getBackwardCompatibilityVersion()));
        }
        catch (Throwable t) {
            CompletableFuture<CommandResult<T>> fail = new CompletableFuture<CommandResult<T>>();
            fail.completeExceptionally(t);
            return fail;
        }
    }
}

