/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.jedis.cas;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.serialization.Mapper;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.util.Pool;

public class JedisBasedProxyManager<K>
extends AbstractCompareAndSwapBasedProxyManager<K> {
    private final RedisApi redisApi;
    private final ExpirationAfterWriteStrategy expirationStrategy;
    private final Mapper<K> keyMapper;

    public static JedisBasedProxyManagerBuilder<byte[]> builderFor(final Pool<Jedis> jedisPool) {
        Objects.requireNonNull(jedisPool);
        RedisApi redisApi = new RedisApi(){

            @Override
            public Object eval(byte[] script, int keyCount, byte[] ... params) {
                try (Jedis jedis = (Jedis)jedisPool.getResource();){
                    Object object = jedis.eval(script, 1, params);
                    return object;
                }
            }

            @Override
            public byte[] get(byte[] key) {
                try (Jedis jedis = (Jedis)jedisPool.getResource();){
                    byte[] byArray = jedis.get(key);
                    return byArray;
                }
            }

            @Override
            public void delete(byte[] key) {
                try (Jedis jedis = (Jedis)jedisPool.getResource();){
                    jedis.del(key);
                }
            }
        };
        return new JedisBasedProxyManagerBuilder<byte[]>(Mapper.BYTES, redisApi);
    }

    public static JedisBasedProxyManagerBuilder<byte[]> builderFor(final JedisCluster jedisCluster) {
        Objects.requireNonNull(jedisCluster);
        RedisApi redisApi = new RedisApi(){

            @Override
            public Object eval(byte[] script, int keyCount, byte[] ... params) {
                return jedisCluster.eval(script, keyCount, params);
            }

            @Override
            public byte[] get(byte[] key) {
                return jedisCluster.get(key);
            }

            @Override
            public void delete(byte[] key) {
                jedisCluster.del(key);
            }
        };
        return new JedisBasedProxyManagerBuilder<byte[]>(Mapper.BYTES, redisApi);
    }

    private JedisBasedProxyManager(JedisBasedProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.redisApi = ((JedisBasedProxyManagerBuilder)builder).redisApi;
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
        this.keyMapper = ((JedisBasedProxyManagerBuilder)builder).keyMapper;
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(K key) {
        final byte[] keyBytes = this.keyMapper.toBytes(key);
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData() {
                return Optional.ofNullable(JedisBasedProxyManager.this.redisApi.get(keyBytes));
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return JedisBasedProxyManager.this.compareAndSwap(keyBytes, originalData, newData, newState);
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(K key) {
        throw new UnsupportedOperationException();
    }

    public void removeProxy(K key) {
        this.redisApi.delete(this.keyMapper.toBytes(key));
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    private Boolean compareAndSwap(byte[] key, byte[] originalData, byte[] newData, RemoteBucketState newState) {
        long ttlMillis = this.calculateTtlMillis(newState);
        if (ttlMillis > 0L) {
            if (originalData == null) {
                byte[][] keysAndArgs = new byte[][]{key, newData, this.encodeLong(ttlMillis)};
                Object res = this.redisApi.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx', 'px', ARGV[2]) then return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs);
                return res != null && !res.equals(0L);
            }
            byte[][] keysAndArgs = new byte[][]{key, originalData, newData, this.encodeLong(ttlMillis)};
            Object res = this.redisApi.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs);
            return res != null && !res.equals(0L);
        }
        if (originalData == null) {
            byte[][] keysAndArgs = new byte[][]{key, newData};
            Object res = this.redisApi.eval("if redis.call('set', KEYS[1], ARGV[1], 'nx') then return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs);
            return res != null && !res.equals(0L);
        }
        byte[][] keysAndArgs = new byte[][]{key, originalData, newData};
        Object res = this.redisApi.eval("if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8), 1, keysAndArgs);
        return res != null && !res.equals(0L);
    }

    private byte[] encodeLong(Long value) {
        return ("" + value).getBytes(StandardCharsets.UTF_8);
    }

    private long calculateTtlMillis(RemoteBucketState state) {
        Optional clock = this.getClientSideConfig().getClientSideClock();
        long currentTimeNanos = clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
        return this.expirationStrategy.calculateTimeToLiveMillis(state, currentTimeNanos);
    }

    private static interface RedisApi {
        public Object eval(byte[] var1, int var2, byte[] ... var3);

        public byte[] get(byte[] var1);

        public void delete(byte[] var1);
    }

    public static class JedisBasedProxyManagerBuilder<K>
    extends AbstractRedisProxyManagerBuilder<JedisBasedProxyManagerBuilder<K>> {
        private final RedisApi redisApi;
        private Mapper<K> keyMapper;

        public <Key> JedisBasedProxyManagerBuilder<Key> withKeyMapper(Mapper<Key> keyMapper) {
            this.keyMapper = Objects.requireNonNull(keyMapper);
            return this;
        }

        private JedisBasedProxyManagerBuilder(Mapper<K> keyMapper, RedisApi redisApi) {
            this.keyMapper = Objects.requireNonNull(keyMapper);
            this.redisApi = Objects.requireNonNull(redisApi);
        }

        public JedisBasedProxyManager<K> build() {
            return new JedisBasedProxyManager(this);
        }
    }
}

