/*
 * Decompiled with CFR 0.152.
 */
package com.buddy.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.buddy.sdk.AccessTokenCallback;
import com.buddy.sdk.BuddyCallback;
import com.buddy.sdk.BuddyClientOptions;
import com.buddy.sdk.BuddyDateDeserializer;
import com.buddy.sdk.BuddyFuture;
import com.buddy.sdk.BuddyFutureCallback;
import com.buddy.sdk.BuddyResult;
import com.buddy.sdk.BuddyServiceClient;
import com.buddy.sdk.UserAuthenticationRequiredCallback;
import com.buddy.sdk.models.TimedMetric;
import com.buddy.sdk.models.User;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class BuddyClient {
    private String app_id;
    private String app_key;
    private BuddyServiceClient serviceClient;
    private BuddyClientOptions options;
    private Context context;
    private Location lastLocation;
    private UserAuthenticationRequiredCallback userAuthCallback;
    public static final String NoRegisterDevice = "__noregdevice";
    private static String DefaultRoot = "https://api.buddyplatform.com";
    private BuddyClientSettings settings;

    public BuddyClient(Context context, String appId, String appKey) {
        this(context, appId, appKey, null);
    }

    public BuddyClient(Context context, String appId, String appKey, BuddyClientOptions options) {
        this.app_id = appId;
        this.app_key = appKey;
        this.context = context;
        BuddyClientSettings settings = this.getSettings();
        this.options = options == null ? new BuddyClientOptions() : options;
        if (options.serviceRoot != null && settings.serviceRoot == null) {
            settings.serviceRoot = options.serviceRoot;
        }
        this.getServiceClient();
    }

    public void setUserAuthenticationRequiredCallback(UserAuthenticationRequiredCallback callback) {
        this.userAuthCallback = callback;
    }

    public void setLastLocation(Location loc) {
        this.lastLocation = loc;
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    private void setDefaultParameters(Map<String, Object> parameters) {
        if (this.lastLocation != null && !parameters.containsKey("location")) {
            parameters.put("location", String.format("%s,%s", this.lastLocation.getLatitude(), this.lastLocation.getLongitude()));
        }
    }

    void runOnUiThread(Runnable r) {
        if (this.context != null) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(r);
        } else {
            r.run();
        }
    }

    void getAccessToken(boolean autoRegister, final AccessTokenCallback callback) {
        String token = this.getSettings().getAccessToken();
        if (token != null) {
            callback.completed(null, token);
        } else if (autoRegister) {
            this.registerDevice(new BuddyCallback<AccessTokenResult>(AccessTokenResult.class){

                @Override
                public void completed(BuddyResult<AccessTokenResult> result) {
                    if (result.getIsSuccess()) {
                        AccessTokenResult atr = result.getResult();
                        BuddyClientSettings settings = BuddyClient.this.getSettings();
                        settings.deviceToken = atr.accessToken;
                        settings.deviceTokenExpires = atr.accessTokenExpires;
                        settings.appVersion = ((BuddyClient)BuddyClient.this).options.appVersion;
                        if (atr.serviceRoot != null) {
                            settings.serviceRoot = atr.serviceRoot;
                        }
                        BuddyClient.this.saveSettings();
                        callback.completed(null, atr.accessToken);
                    } else {
                        callback.completed(result.convert(Boolean.FALSE), null);
                    }
                }
            });
        } else {
            callback.completed(null, null);
        }
    }

    public String getServiceRoot() {
        return this.getSettings().getServiceRoot();
    }

    BuddyServiceClient getServiceClient() {
        if (this.serviceClient == null) {
            this.serviceClient = new BuddyServiceClient(this);
            this.serviceClient.setSynchronousMode(this.options.synchronousMode);
        }
        return this.serviceClient;
    }

    public <T> Future<BuddyResult<T>> get(String path, Map<String, Object> parameters, Class<T> clazz) {
        return this.getServiceClient().makeRequest("GET", path, parameters, null, clazz);
    }

    public <T> Future<BuddyResult<T>> get(String path, Map<String, Object> parameters, BuddyCallback<T> callback) {
        return this.getServiceClient().makeRequest("GET", path, parameters, callback, null);
    }

    public <T> Future<BuddyResult<T>> post(String path, Map<String, Object> parameters, Class<T> clazz) {
        return this.getServiceClient().makeRequest("POST", path, parameters, null, clazz);
    }

    public <T> Future<BuddyResult<T>> post(String path, Map<String, Object> parameters, BuddyCallback<T> callback) {
        return this.getServiceClient().makeRequest("POST", path, parameters, callback, null);
    }

    public <T> Future<BuddyResult<T>> patch(String path, Map<String, Object> parameters, Class<T> clazz) {
        return this.getServiceClient().makeRequest("PATCH", path, parameters, null, clazz);
    }

    public <T> Future<BuddyResult<T>> patch(String path, Map<String, Object> parameters, BuddyCallback<T> callback) {
        return this.getServiceClient().makeRequest("PATCH", path, parameters, callback, null);
    }

    public <T> Future<BuddyResult<T>> delete(String path, Map<String, Object> parameters, Class<T> clazz) {
        return this.getServiceClient().makeRequest("DELETE", path, parameters, null, clazz);
    }

    public <T> Future<BuddyResult<T>> delete(String path, Map<String, Object> parameters, BuddyCallback<T> callback) {
        return this.getServiceClient().makeRequest("DELETE", path, parameters, callback, null);
    }

    public <T> Future<BuddyResult<T>> put(String path, Map<String, Object> parameters, Class<T> clazz) {
        return this.getServiceClient().makeRequest("PUT", path, parameters, null, clazz);
    }

    public <T> Future<BuddyResult<T>> put(String path, Map<String, Object> parameters, BuddyCallback<T> callback) {
        return this.getServiceClient().makeRequest("PUT", path, parameters, callback, null);
    }

    private String getDeviceId() {
        if (this.context != null) {
            return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        }
        return null;
    }

    private void registerDevice(BuddyCallback<AccessTokenResult> callback) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("platform", "Android");
        parameters.put("model", Build.MODEL);
        parameters.put("osVersion", Build.VERSION.RELEASE);
        if (this.options.deviceTag != null) {
            parameters.put("tag", this.options.deviceTag);
        }
        BuddyClientSettings settings = this.getSettings();
        if (settings.pushToken != null) {
            parameters.put("pushToken", settings.pushToken);
        }
        if (this.context != null) {
            PackageManager manager = this.context.getPackageManager();
            PackageInfo info = null;
            try {
                info = manager.getPackageInfo(this.context.getPackageName(), 0);
                parameters.put("appVersion", String.format("%s (%d)", info.versionName, info.versionCode));
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
        parameters.put("uniqueId", this.getDeviceId());
        parameters.put("appid", this.app_id);
        parameters.put("appkey", this.app_key);
        if (this.options.appVersion != null) {
            parameters.put("appversion", this.options.appVersion);
        }
        parameters.put(NoRegisterDevice, true);
        this.post("/devices", parameters, callback);
    }

    public Future<BuddyResult<User>> getCurrentUser(final BuddyCallback<User> callback) {
        return this.get("/users/me", null, new BuddyCallback<User>(User.class){

            @Override
            public void completed(BuddyResult<User> result) {
                if (callback != null) {
                    callback.completed(result);
                }
            }
        });
    }

    private BuddyCallback<User> getUserCallback(final BuddyCallback<User> callback) {
        return new BuddyCallback<User>(User.class){

            @Override
            public void completed(BuddyResult<User> result) {
                JsonObject json;
                if (result.getIsSuccess() && (json = result.getResult().getJsonObject()) != null && json.has("accessToken")) {
                    BuddyClientSettings settings = BuddyClient.this.getSettings();
                    settings.userToken = json.get("accessToken").getAsString();
                    settings.userTokenExpires = BuddyDateDeserializer.deserialize(json.get("accessTokenExpires").getAsString());
                    settings.userid = result.getResult().id;
                    BuddyClient.this.saveSettings();
                }
                if (callback != null) {
                    callback.completed(result);
                }
            }
        };
    }

    public Future<BuddyResult<User>> createUser(String username, String password, String firstName, String lastName, String email, Date dateOfBirth, String gender, String tag, BuddyCallback<User> callback) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("password", password);
        parameters.put("firstname", firstName);
        parameters.put("lastname", lastName);
        parameters.put("email", email);
        if (dateOfBirth != null) {
            parameters.put("dateOfBirth", dateOfBirth);
        }
        if (gender != null) {
            parameters.put("gender", gender);
        }
        parameters.put("tag", tag);
        return this.post("/users", parameters, this.getUserCallback(callback));
    }

    public Future<BuddyResult<User>> loginUser(String username, String password, BuddyCallback<User> callback) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("password", password);
        return this.post("/users/login", parameters, this.getUserCallback(callback));
    }

    public Future<BuddyResult<Boolean>> logoutUser(final BuddyCallback<Boolean> callback) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        final BuddyFuture<BuddyResult<Boolean>> promise = new BuddyFuture<BuddyResult<Boolean>>();
        BuddyFuture handle = (BuddyFuture)this.post("/users/me/logout", parameters, new BuddyCallback<AccessTokenResult>(AccessTokenResult.class){

            @Override
            public void completed(BuddyResult<AccessTokenResult> result) {
                if (result.getIsSuccess()) {
                    BuddyClientSettings settings = BuddyClient.this.getSettings();
                    AccessTokenResult r = result.getResult();
                    boolean hadUser = settings.userid != null && settings.userToken != null;
                    settings.deviceTokenExpires = r.accessTokenExpires;
                    settings.deviceToken = r.accessToken;
                    settings.userToken = null;
                    BuddyClient.this.saveSettings();
                    if (hadUser && BuddyClient.this.userAuthCallback != null) {
                        BuddyClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                BuddyClient.this.userAuthCallback.authenticate();
                            }
                        });
                    }
                }
                if (callback != null) {
                    callback.completed(result.convert(Boolean.TRUE));
                }
            }
        });
        handle.continueWith(new BuddyFutureCallback<BuddyResult<AccessTokenResult>>(){

            @Override
            public void completed(BuddyFuture<BuddyResult<AccessTokenResult>> future) {
                try {
                    promise.setValue(future.get().convert(future.get().getIsSuccess()));
                    return;
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                promise.setValue(null);
            }
        });
        return promise;
    }

    public Future<BuddyResult<TimedMetric>> recordMetricEvent(String eventName, Map<String, Object> values, final int timeoutInSeconds, final BuddyCallback<TimedMetric> callback) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (values != null) {
            parameters.put("values", values);
        }
        if (timeoutInSeconds > 0) {
            parameters.put("timeoutInSeconds", timeoutInSeconds);
        }
        try {
            eventName = URLEncoder.encode(eventName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return this.post("/metrics/events/" + eventName, parameters, new BuddyCallback<TimedMetric>(TimedMetric.class){

            @Override
            public void completed(BuddyResult<TimedMetric> result) {
                if (result.getIsSuccess() && timeoutInSeconds > 0) {
                    TimedMetric tm = result.getResult();
                    tm.setBuddyClient(BuddyClient.this);
                }
                if (callback != null) {
                    callback.completed(result);
                }
            }
        });
    }

    public Future<BuddyResult<Boolean>> setPushToken(String pushToken, final BuddyCallback<Boolean> callback) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (pushToken != null) {
            parameters.put("pushToken", pushToken);
        }
        BuddyClientSettings settings = this.getSettings();
        settings.pushToken = pushToken;
        this.saveSettings();
        final BuddyFuture<BuddyResult<Boolean>> promise = new BuddyFuture<BuddyResult<Boolean>>();
        BuddyFuture handle = (BuddyFuture)this.patch("/devices/current", parameters, new BuddyCallback<Object>(Object.class){

            @Override
            public void completed(BuddyResult<Object> result) {
                if (callback != null) {
                    callback.completed(result.convert(result.getIsSuccess()));
                }
            }
        });
        handle.continueWith(new BuddyFutureCallback<BuddyResult<Object>>(){

            @Override
            public void completed(BuddyFuture<BuddyResult<Object>> future) {
                try {
                    promise.setValue(future.get().convert(Boolean.TRUE));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        });
        return promise;
    }

    public void recordNotificationReceived(Intent message) {
        String id = message.getStringExtra("_bId");
        if (id != null && id.length() > 0) {
            this.post(String.format("/notifications/received/%s", id), null, (Class)null);
        }
    }

    private SharedPreferences getPreferences() {
        if (this.context != null) {
            SharedPreferences preferences = this.context.getSharedPreferences(String.format("com.buddy-%s-%s", this.app_id, this.options == null ? null : this.options.settingsPrefix), 0);
            return preferences;
        }
        return null;
    }

    private void saveSettings() {
        SharedPreferences preferences = this.getPreferences();
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            String json = new Gson().toJson((Object)this.settings);
            editor.putString(String.format("%s", this.app_id), json);
            editor.commit();
        }
    }

    private BuddyClientSettings getSettings() {
        if (this.settings == null) {
            String json;
            SharedPreferences preferences = this.getPreferences();
            if (preferences != null && (json = preferences.getString(String.format("%s", this.app_id), null)) != null) {
                this.settings = (BuddyClientSettings)new Gson().fromJson(json, BuddyClientSettings.class);
            }
            if (this.settings == null) {
                this.settings = new BuddyClientSettings();
            }
        }
        return this.settings;
    }

    void handleError(BuddyResult result) {
        String error = result.getError();
        if (error != null) {
            BuddyClientSettings settings = this.getSettings();
            if (error.equals("AuthAppCredentialsInvalid") || error.equals("AuthAccessTokenInvalid")) {
                settings.userToken = null;
                settings.deviceToken = null;
                this.saveSettings();
            } else if (error.equals("AuthUserAccessTokenRequired") && this.userAuthCallback != null) {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BuddyClient.this.userAuthCallback.authenticate();
                    }
                });
            }
        }
    }

    private class BuddyClientSettings {
        public String serviceRoot;
        public String deviceToken;
        public Date deviceTokenExpires;
        public String userToken;
        public Date userTokenExpires;
        public String userid;
        public String pushToken;
        public String appVersion;

        private BuddyClientSettings() {
        }

        public String getAccessToken() {
            Date now = new Date();
            if (this.userToken != null && this.userTokenExpires.after(now)) {
                return this.userToken;
            }
            if (this.deviceToken != null && this.deviceTokenExpires.after(now)) {
                return this.deviceToken;
            }
            return null;
        }

        public String getServiceRoot() {
            if (this.serviceRoot == null) {
                return DefaultRoot;
            }
            return this.serviceRoot;
        }
    }

    private class AccessTokenResult {
        public String accessToken;
        public Date accessTokenExpires;
        public String serviceRoot;

        private AccessTokenResult() {
        }
    }
}

