/*
 * Decompiled with CFR 0.152.
 */
package com.buddy.sdk;

import com.buddy.sdk.BuddyFutureCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class BuddyFuture<V>
implements Future<V> {
    private boolean done;
    private V value;
    private CountDownLatch waitHandle = new CountDownLatch(1);
    private Object SyncObj = new Object();
    private List<CallbackWrapper> callbacks;

    public BuddyFuture<V> continueWith(BuddyFutureCallback callback) {
        if (!this.done) {
            if (this.callbacks == null) {
                this.callbacks = new ArrayList<CallbackWrapper>();
            }
            CallbackWrapper wrapper = new CallbackWrapper();
            wrapper.callback = callback;
            wrapper.handle = new BuddyFuture<V>();
            this.callbacks.add(wrapper);
            return wrapper.handle;
        }
        callback.completed(this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(V val) {
        Object object = this.SyncObj;
        synchronized (object) {
            this.value = val;
            if (!this.done) {
                this.done = true;
                if (this.callbacks != null) {
                    for (CallbackWrapper cb : this.callbacks) {
                        cb.handle.setValue(val);
                    }
                }
                this.SyncObj.notify();
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object = this.SyncObj;
        synchronized (object) {
            if (!this.done) {
                this.SyncObj.wait();
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            Object object = this.SyncObj;
            synchronized (object) {
                this.SyncObj.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
            }
        }
        return this.value;
    }

    private class CallbackWrapper {
        public BuddyFutureCallback callback;
        public BuddyFuture handle;

        private CallbackWrapper() {
        }
    }
}

