/*
 * Decompiled with CFR 0.152.
 */
package com.buddy.sdk;

import android.content.Context;
import android.os.Looper;
import android.util.Log;
import com.buddy.sdk.AccessTokenCallback;
import com.buddy.sdk.BuddyCallback;
import com.buddy.sdk.BuddyClient;
import com.buddy.sdk.BuddyDateDeserializer;
import com.buddy.sdk.BuddyFile;
import com.buddy.sdk.BuddyFuture;
import com.buddy.sdk.BuddyFutureCallback;
import com.buddy.sdk.BuddyResult;
import com.buddy.sdk.JsonEnvelope;
import com.buddy.sdk.JsonEnvelopeDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.JsonHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.SyncHttpClient;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.json.JSONObject;

class BuddyServiceClient {
    public static final String GET = "GET";
    public static final String PUT = "PUT";
    public static final String POST = "POST";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    BuddyClient _parent;
    AsyncHttpClient client;
    static Map<String, Method> clientMethods = new HashMap<String, Method>();
    private boolean syncMode;
    private static final String DefaultContentType = "application/json";

    public BuddyServiceClient(BuddyClient parent) {
        this._parent = parent;
        this.setSynchronousMode(false);
    }

    public void setSynchronousMode(boolean value) {
        if (value != this.syncMode) {
            this.client = null;
            this.syncMode = value;
        }
    }

    public boolean getSynchronousMode() {
        return this.syncMode;
    }

    private AsyncHttpClient getHttpClient() {
        boolean isSyncMode;
        boolean bl = isSyncMode = Looper.myLooper() == null || this.syncMode;
        if (this.client == null || this.client instanceof SyncHttpClient != isSyncMode) {
            this.client = isSyncMode ? new SyncHttpClient() : new AsyncHttpClient();
        }
        return this.client;
    }

    private static <T> BuddyResult<T> parseBuddyResponse(Class<T> type, int statusCode, String response) {
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new BuddyDateDeserializer()).registerTypeAdapter(JsonEnvelope.class, new JsonEnvelopeDeserializer<T>(type)).create();
        JsonEnvelope result = (JsonEnvelope)gson.fromJson(response, JsonEnvelope.class);
        result.status = statusCode;
        return new BuddyResult(result);
    }

    private static boolean isFile(Object obj) {
        return obj instanceof BuddyFile;
    }

    private Method getClientMethod(String verb) {
        Method m = clientMethods.get(verb.toUpperCase(Locale.getDefault()));
        if (m != null) {
            return m;
        }
        try {
            m = AsyncHttpClient.class.getDeclaredMethod(verb.toLowerCase(Locale.getDefault()), Context.class, String.class, Header[].class, HttpEntity.class, String.class, ResponseHandlerInterface.class);
        }
        catch (NoSuchMethodException nsmEx) {
            m = null;
        }
        clientMethods.put(verb.toUpperCase(Locale.getDefault()), m);
        return m;
    }

    private void logResult(JSONObject result) {
        String json = result.toString();
        Log.d((String)"BuddySdk", (String)json);
    }

    private <T> BuddyFuture<BuddyResult<T>> makeRequestCore(String verb, String path, String accessToken, Map<String, Object> parameters, final BuddyCallback<T> callback, Class<T> clazz) {
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        String root = this._parent.getServiceRoot();
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String url = String.format("%s/%s", root, path);
        if (accessToken != null) {
            headerList.add(new BasicHeader("Authorization", String.format("Buddy %s", accessToken)));
        }
        final BuddyFuture<BuddyResult<T>> promise = new BuddyFuture<BuddyResult<T>>();
        Class<T> rClass = clazz;
        if (rClass == null && callback != null) {
            rClass = callback.getResultClass();
        }
        final Class<T> resultClass = rClass;
        final JsonHttpResponseHandler jsonHandler = new JsonHttpResponseHandler(){

            public void onSuccess(int statusCode, Header[] headers, JSONObject response) {
                BuddyServiceClient.this.logResult(response);
                String json = response.toString();
                BuddyResult result = BuddyServiceClient.parseBuddyResponse(resultClass, statusCode, json);
                if (callback != null) {
                    callback.completed(result);
                }
                promise.setValue(result);
            }

            public void onFailure(int statusCode, Header[] headers, Throwable throwable, JSONObject errorResponse) {
                JsonEnvelope<Object> env = null;
                if (errorResponse != null) {
                    env = new JsonEnvelope<Object>(errorResponse, null);
                    BuddyServiceClient.this.logResult(errorResponse);
                } else {
                    env = new JsonEnvelope();
                    env.error = "NoInternetConnection";
                    env.message = "No internet connection is available.";
                }
                BuddyResult result = new BuddyResult(env);
                if (callback != null) {
                    callback.completed(result);
                }
                promise.setValue(result);
                BuddyServiceClient.this._parent.handleError(result);
            }

            public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
                JsonEnvelope env = null;
                env = new JsonEnvelope();
                env.error = "UnexpectedServiceError";
                env.message = responseString;
                BuddyResult result = new BuddyResult(env);
                if (callback != null) {
                    callback.completed(result);
                }
                promise.setValue(result);
            }
        };
        Header[] headers = headerList.toArray(new Header[0]);
        headerList.add(new BasicHeader("Accept", DefaultContentType));
        RequestParams requestParams = new RequestParams();
        AsyncHttpClient httpClient = this.getHttpClient();
        if (verb.toUpperCase(Locale.getDefault()).equals(GET)) {
            boolean isFile;
            boolean bl = isFile = resultClass != null && BuddyFile.class.isAssignableFrom(resultClass);
            if (parameters != null) {
                for (Map.Entry<String, Object> cursor : parameters.entrySet()) {
                    requestParams.put(cursor.getKey(), cursor.getValue());
                }
            }
            Object handler = jsonHandler;
            Log.d((String)"BuddySdk", (String)String.format("%s %s", verb, url));
            if (isFile) {
                handler = new AsyncHttpResponseHandler(){

                    public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                        ByteArrayInputStream result = new ByteArrayInputStream(responseBody);
                        String contentTypeHeader = "application/octet-stream";
                        for (Header h : headers) {
                            if (!h.getName().toLowerCase(Locale.getDefault()).equals("content-type")) continue;
                            contentTypeHeader = h.getValue();
                        }
                        BuddyFile file = new BuddyFile(result, contentTypeHeader);
                        JsonEnvelope env = new JsonEnvelope();
                        env.result = file;
                        BuddyResult r = new BuddyResult(env);
                        if (callback != null) {
                            callback.completed(r);
                        }
                        promise.setValue(r);
                    }

                    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                        jsonHandler.setUseSynchronousMode(this.getUseSynchronousMode());
                        jsonHandler.onFailure(statusCode, headers, responseBody, error);
                    }
                };
            }
            httpClient.get(null, url, headers, requestParams, (ResponseHandlerInterface)handler);
        } else {
            Method methodToInvoke;
            StringEntity entity = null;
            String contentType = DefaultContentType;
            if (parameters != null) {
                HashMap<String, Object> files = new HashMap<String, Object>();
                HashMap<String, Object> nonFiles = new HashMap<String, Object>();
                for (Map.Entry<String, Object> cursor : parameters.entrySet()) {
                    Object obj = cursor.getValue();
                    if (BuddyServiceClient.isFile(obj)) {
                        files.put(cursor.getKey(), obj);
                        continue;
                    }
                    nonFiles.put(cursor.getKey(), obj);
                }
                String bodyJson = new Gson().toJson(nonFiles);
                Log.d((String)"BuddySdk", (String)String.format("%s %s \r\n -> %s", verb, url, bodyJson));
                if (files.size() > 0) {
                    ByteArrayInputStream stream = new ByteArrayInputStream(bodyJson.getBytes());
                    requestParams.put("body", (InputStream)stream, "body", DefaultContentType);
                    for (Map.Entry cursor : files.entrySet()) {
                        BuddyFile file = (BuddyFile)cursor.getValue();
                        if (file.getStream() != null) {
                            requestParams.put((String)cursor.getKey(), file.getStream(), (String)cursor.getKey(), file.getContentType());
                            continue;
                        }
                        if (file.getFile() == null) continue;
                        try {
                            requestParams.put((String)cursor.getKey(), file.getFile(), file.getContentType());
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        entity = requestParams.getEntity(new ResponseHandlerInterface(){

                            public void sendResponseMessage(HttpResponse response) throws IOException {
                            }

                            public void sendStartMessage() {
                            }

                            public void sendFinishMessage() {
                            }

                            public void sendProgressMessage(int bytesWritten, int bytesTotal) {
                                Log.d((String)"BuddySdk", (String)String.format("%d/%d", bytesWritten, bytesTotal));
                            }

                            public void sendCancelMessage() {
                            }

                            public void sendSuccessMessage(int statusCode, Header[] headers, byte[] responseBody) {
                            }

                            public void sendFailureMessage(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
                            }

                            public void sendRetryMessage(int retryNo) {
                            }

                            public URI getRequestURI() {
                                return null;
                            }

                            public Header[] getRequestHeaders() {
                                return new Header[0];
                            }

                            public void setRequestURI(URI requestURI) {
                            }

                            public void setRequestHeaders(Header[] requestHeaders) {
                            }

                            public void setUseSynchronousMode(boolean useSynchronousMode) {
                            }

                            public boolean getUseSynchronousMode() {
                                return BuddyServiceClient.this.syncMode;
                            }
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    contentType = null;
                } else {
                    try {
                        entity = new StringEntity(bodyJson);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((methodToInvoke = this.getClientMethod(verb)) == null) {
                jsonHandler.onFailure(0, new Header[0], "", (Throwable)new MethodNotSupportedException("Verb " + verb + " not supported."));
            } else {
                try {
                    try {
                        methodToInvoke.invoke((Object)httpClient, null, url, headers, entity, contentType, jsonHandler);
                    }
                    catch (InvocationTargetException e) {
                        JsonEnvelope env = new JsonEnvelope();
                        env.error = "UnexpectedSdkError";
                        env.status = 0;
                        env.errorCode = -1;
                        env.message = e.getTargetException().toString();
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.getTargetException().printStackTrace(pw);
                        Log.e((String)"BuddySdk", (String)sw.toString());
                        BuddyResult newResult = new BuddyResult(env);
                        if (callback != null) {
                            callback.completed(newResult);
                        }
                        promise.setValue(newResult);
                    }
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        return promise;
    }

    protected <T> Future<BuddyResult<T>> makeRequest(final String verb, final String path, final Map<String, Object> parameters, final BuddyCallback<T> callback, final Class<T> clazz) {
        boolean autoRegister = true;
        if (parameters != null && parameters.containsKey("__noregdevice")) {
            parameters.remove("__noregdevice");
            autoRegister = false;
        }
        final BuddyFuture<BuddyResult<T>> promise = new BuddyFuture<BuddyResult<T>>();
        this._parent.getAccessToken(autoRegister, new AccessTokenCallback(){

            @Override
            public void completed(BuddyResult<Boolean> error, String accessToken) {
                if (error != null) {
                    BuddyResult<Object> newResult = error.convert(null);
                    if (callback != null) {
                        callback.completed(newResult);
                    }
                    promise.setValue(newResult);
                } else {
                    final BuddyFuture innerPromise = BuddyServiceClient.this.makeRequestCore(verb, path, accessToken, parameters, callback, clazz);
                    innerPromise.continueWith(new BuddyFutureCallback(){

                        public void completed(BuddyFuture future) {
                            try {
                                promise.setValue(innerPromise.get());
                            }
                            catch (InterruptedException e) {
                            }
                            catch (ExecutionException executionException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        });
        return promise;
    }
}

