/*
 * Decompiled with CFR 0.152.
 */
package test.com.buddy.sdk;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.test.InstrumentationTestCase;
import com.buddy.sdk.BuddyClient;
import com.buddy.sdk.BuddyClientOptions;
import com.buddy.sdk.BuddyFile;
import com.buddy.sdk.BuddyResult;
import com.buddy.sdk.models.Picture;
import com.buddy.sdk.models.User;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.Assert;

public class BasicTest
extends InstrumentationTestCase {
    private static final String TargetUrl = null;
    private static final String AppId = "[your test app id]";
    private static final String AppKey = "[your test app key]";

    private BuddyClient getClient() {
        return this.getClient(AppId, AppKey, true);
    }

    private BuddyClient getClient(String appid, String appkey, boolean syncMode) {
        BuddyClientOptions options = new BuddyClientOptions();
        options.synchronousMode = syncMode;
        options.serviceRoot = TargetUrl;
        BuddyClient client = new BuddyClient(null, appid == null ? "appid" : appid, appkey == null ? "appkey" : appkey, options);
        return client;
    }

    public void testPingSuccess() throws Exception {
        BuddyClient client = this.getClient();
        Future<BuddyResult<String>> handle = client.get("/service/ping", null, String.class);
        BuddyResult<String> result = handle.get();
        BasicTest.assertNotNull(result);
        BasicTest.assertNull((Object)result.getError());
        BasicTest.assertEquals((String)"Pong", (String)result.getResult());
    }

    public void testPingFail() throws Exception {
        BuddyClient client = this.getClient(null, null, true);
        Future<BuddyResult<String>> handle = client.get("/service/ping", null, String.class);
        BuddyResult<String> result = handle.get();
        BasicTest.assertNotNull(result);
        BasicTest.assertEquals((String)"AuthAppCredentialsInvalid", (String)result.getError());
        BasicTest.assertEquals(null, (String)result.getResult());
    }

    public void testCreateUser() throws Exception {
        BuddyClient client = this.getClient();
        String newUser = String.format(Locale.getDefault(), "%s-%d", "testuser-", new Date().getTime());
        Future<BuddyResult<User>> handle = client.createUser(newUser, "password", null, null, null, null, null, null, null);
        BuddyResult<User> result = handle.get();
        BasicTest.assertNotNull(result);
        BasicTest.assertNull((Object)result.getError());
        BasicTest.assertEquals((String)newUser, (String)result.getResult().userName);
        Future<BuddyResult<User>> handle2 = client.getCurrentUser(null);
        result = handle2.get();
        BasicTest.assertEquals((String)newUser, (String)result.getResult().userName);
    }

    public void testLoginUser() throws Exception {
        BuddyClient client = this.getClient();
        Future<BuddyResult<User>> handle = client.loginUser("shawn", "password", null);
        BuddyResult<User> result = handle.get();
        BasicTest.assertNotNull(result);
        BasicTest.assertNull((Object)result.getError());
        BasicTest.assertEquals((String)"shawn", (String)result.getResult().userName);
    }

    public void testRunInThread() throws Exception {
        final BuddyClient client = this.getClient(AppId, AppKey, false);
        AsyncTask<Void, Void, Boolean> task = new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... params) {
                Future<BuddyResult<User>> promise = client.getCurrentUser(null);
                try {
                    promise.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                return true;
            }
        };
        task.execute((Object[])new Void[0]);
    }

    public void testUploadFile() throws Exception {
        BuddyClient client = this.getClient();
        Future<BuddyResult<User>> handle = client.loginUser("shawn", "password", null);
        handle.get();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Bitmap bitmap = Bitmap.createBitmap((int)30, (int)30, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        MyRoundCornerDrawable drawable = new MyRoundCornerDrawable(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        byte[] bytes = stream.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        parameters.put("caption", "From Android");
        parameters.put("data", new BuddyFile(is, "image/png"));
        Future<BuddyResult<Picture>> handle2 = client.post("/pictures", parameters, Picture.class);
        handle2.get();
        BasicTest.assertNotNull((Object)handle2.get().getResult());
        BasicTest.assertEquals((String)"From Android", (String)handle2.get().getResult().caption);
        parameters.clear();
        Future<BuddyResult<BuddyFile>> handle3 = client.get(String.format("/pictures/%s/file", handle2.get().getResult().id), null, BuddyFile.class);
        handle3.get();
        BasicTest.assertNotNull(handle3.get());
        BuddyFile file = handle3.get().getResult();
        BasicTest.assertNotNull((Object)file);
        BasicTest.assertNotNull((Object)file.getStream());
        BasicTest.assertEquals((String)"image/png", (String)file.getContentType());
        InputStream fileStream = file.getStream();
        BasicTest.assertEquals((int)bytes.length, (int)fileStream.available());
        byte[] buffer = new byte[fileStream.available()];
        fileStream.read(buffer, 0, buffer.length);
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == bytes[i]) continue;
            Assert.fail((String)("Bytes not equal at " + i));
        }
    }

    private class MyRoundCornerDrawable
    extends Drawable {
        private Paint paint;

        public MyRoundCornerDrawable(Bitmap bitmap) {
            BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            this.paint.setShader((Shader)shader);
        }

        public void draw(Canvas canvas) {
            int height = this.getBounds().height();
            int width = this.getBounds().width();
            RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
            canvas.drawRoundRect(rect, 30.0f, 30.0f, this.paint);
        }

        public void setAlpha(int alpha) {
            this.paint.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.paint.setColorFilter(cf);
        }

        public int getOpacity() {
            return -3;
        }
    }
}

