/*
 * Decompiled with CFR 0.152.
 */
package com.budjb.spring.distributed.cluster.hazelcast;

import com.budjb.spring.distributed.cluster.AbstractClusterManager;
import com.budjb.spring.distributed.cluster.ClusterConfigurationProperties;
import com.budjb.spring.distributed.cluster.ClusterMember;
import com.budjb.spring.distributed.cluster.Instruction;
import com.budjb.spring.distributed.cluster.hazelcast.AutowiringCallableWrapper;
import com.budjb.spring.distributed.cluster.hazelcast.HazelcastClusterMember;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;

public class HazelcastClusterManager
extends AbstractClusterManager
implements InitializingBean {
    private static final String HAZELCAST_MAP_NAME = "distributed-properties";
    private static final String EXECUTOR_NAME = "cluster-management";
    private final HazelcastInstance hazelcastInstance;
    private IExecutorService executorService;

    public HazelcastClusterManager(HazelcastInstance hazelcastInstance, ClusterConfigurationProperties clusterConfigurationProperties) {
        super(clusterConfigurationProperties);
        this.hazelcastInstance = hazelcastInstance;
    }

    public List<ClusterMember> getClusterMembers() {
        return this.hazelcastInstance.getCluster().getMembers().stream().map(HazelcastClusterMember::new).collect(Collectors.toList());
    }

    protected <T> Future<T> submitInstruction(ClusterMember clusterMember, Instruction<? extends T> instruction) {
        return this.executorService.submit(new AutowiringCallableWrapper<T>(instruction), (MemberSelector)new SingleMemberSelector(((HazelcastClusterMember)clusterMember).getMember()));
    }

    protected Map<String, Object> getProperties() {
        return this.hazelcastInstance.getMap(HAZELCAST_MAP_NAME);
    }

    public void afterPropertiesSet() {
        this.executorService = this.hazelcastInstance.getExecutorService(EXECUTOR_NAME);
    }

    private static class SingleMemberSelector
    implements MemberSelector {
        final Member member;

        public SingleMemberSelector(Member member) {
            this.member = member;
        }

        public boolean select(Member member) {
            return this.member == member;
        }
    }
}

