/*
 * Decompiled with CFR 0.152.
 */
package com.buession.io;

import com.buession.core.utils.Assert;
import com.buession.core.utils.KeyValueParser;
import com.buession.core.validator.Validate;
import java.util.Objects;
import java.util.StringJoiner;
import javax.validation.constraints.NotEmpty;

public final class MimeType {
    private final String type;
    private final String subtype;
    private String description;

    public MimeType(@NotEmpty String mimeType) {
        Assert.isBlank((String)mimeType, (String)"MimeType string cloud empty or null.");
        if (!Validate.isMimeType((CharSequence)mimeType)) {
            throw new IllegalArgumentException("Illegal MimeType: " + mimeType);
        }
        KeyValueParser keyValueParser = new KeyValueParser(mimeType, '/');
        this.type = keyValueParser.getKey().toLowerCase();
        this.subtype = keyValueParser.getValue().toLowerCase();
    }

    public MimeType(@NotEmpty String type, @NotEmpty String subtype) {
        this.type = type.toLowerCase();
        this.subtype = subtype.toLowerCase();
    }

    public MimeType(@NotEmpty String type, @NotEmpty String subtype, String description) {
        this(type, subtype);
        this.description = description;
    }

    public static MimeType parse(String mimeType) {
        Assert.isBlank((String)mimeType, (String)"MimeType string cloud empty or null.");
        KeyValueParser keyValueParser = new KeyValueParser(mimeType, '/');
        return new MimeType(keyValueParser.getKey(), keyValueParser.getValue());
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return 16 * (this.type.hashCode() + this.subtype.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MimeType) {
            MimeType that = (MimeType)object;
            return Objects.equals(this.type, that.type) && Objects.equals(this.subtype, that.subtype);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner("/").add(this.type).add(this.subtype).toString();
    }
}

