/*
 * Decompiled with CFR 0.152.
 */
package com.buession.io.file;

import com.buession.core.validator.Validate;
import com.buession.io.MimeType;
import com.buession.io.file.MimeTypeDetector;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;

public abstract class AbstractMimeTypeDetector
implements MimeTypeDetector {
    protected volatile boolean initialized = false;
    protected HashMap<String, MimeType> internalMimetypes = new HashMap();

    public AbstractMimeTypeDetector() {
        this.initialize();
    }

    @Override
    public final MimeType probe(String path) throws IOException {
        if (Validate.hasText((CharSequence)path)) {
            return this.implProbeMimeType(path);
        }
        throw new NullPointerException("File path is null or empty.");
    }

    @Override
    public final MimeType probe(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("'file' is null");
        }
        return this.probe(file.toPath());
    }

    @Override
    public final MimeType probe(Path path) {
        if (path == null) {
            throw new NullPointerException("'file' is null");
        }
        return this.implProbeMimeType(path);
    }

    protected abstract void initialize();

    protected static String getExtension(String path) {
        int temp;
        String extension = "";
        if (Validate.isNotEmpty((CharSequence)path) && (temp = path.indexOf(46)) >= 0 && temp < path.length() - 1) {
            extension = path.substring(temp + 1);
        }
        return extension;
    }

    protected abstract MimeType implProbeMimeType(String var1);

    protected abstract MimeType implProbeMimeType(Path var1);

    protected void putIfAbsent(String extension, String contentType, String description) {
        if (Validate.isNotEmpty((CharSequence)extension) && Validate.isNotEmpty((CharSequence)contentType) && !this.internalMimetypes.containsKey(extension)) {
            MimeType mimeType = MimeType.parse(contentType);
            mimeType.setDescription(description);
            this.internalMimetypes.put(extension, mimeType);
        }
    }

    protected static MimeType parse(String s, String description) {
        int slash = s.indexOf(47);
        int semicolon = s.indexOf(59);
        if (slash < 0) {
            return null;
        }
        String type = AbstractMimeTypeDetector.parseType(s.substring(0, slash));
        if (!AbstractMimeTypeDetector.isValidToken(type)) {
            return null;
        }
        String subtype = AbstractMimeTypeDetector.parseType(semicolon < 0 ? s.substring(slash + 1) : s.substring(slash + 1, semicolon));
        if (!AbstractMimeTypeDetector.isValidToken(subtype)) {
            return null;
        }
        return new MimeType(type, subtype, description);
    }

    private static String parseType(String type) {
        return type.trim().toLowerCase(Locale.ENGLISH);
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && "()<>@,;:/[]?=\\\"".indexOf(c) < 0;
    }

    private static boolean isValidToken(String str) {
        int strLength = str.length();
        if (strLength == 0) {
            return false;
        }
        for (int i = 0; i < strLength; ++i) {
            if (AbstractMimeTypeDetector.isTokenChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

