/*
 * Decompiled with CFR 0.152.
 */
package com.buession.io.file;

import com.buession.core.validator.Validate;
import com.buession.io.MimeType;
import com.buession.io.file.AbstractMimeTypeDetector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMimeTypeDetector
extends AbstractMimeTypeDetector {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMimeTypeDetector.class);

    public DefaultMimeTypeDetector() {
        this.initialize();
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected MimeType implProbeMimeType(String path) {
        MimeType mimeType;
        if (Validate.isBlank((CharSequence)path)) {
            return null;
        }
        String extension = DefaultMimeTypeDetector.getExtension(path);
        if (extension.isEmpty()) {
            return null;
        }
        this.loadMimetypes();
        if (Validate.isEmpty((Map)this.internalMimetypes)) {
            return null;
        }
        do {
            if ((mimeType = (MimeType)this.internalMimetypes.get(extension)) != null) continue;
            extension = DefaultMimeTypeDetector.getExtension(extension);
        } while (mimeType == null && !extension.isEmpty());
        return mimeType;
    }

    @Override
    protected MimeType implProbeMimeType(Path path) {
        Path fn = path.getFileName();
        if (fn == null) {
            return null;
        }
        return this.implProbeMimeType(fn.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMimetypes() {
        if (!this.initialized) {
            DefaultMimeTypeDetector defaultMimeTypeDetector = this;
            synchronized (defaultMimeTypeDetector) {
                if (!this.initialized) {
                    InputStream is = DefaultMimeTypeDetector.class.getResourceAsStream("/mime.conf");
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        String entry = "";
                        while ((line = br.readLine()) != null) {
                            if ((entry = entry + line).endsWith("\\")) {
                                entry = entry.substring(0, entry.length() - 1);
                                continue;
                            }
                            this.parseMimeEntry(entry);
                            entry = "";
                        }
                        if (!entry.isEmpty()) {
                            this.parseMimeEntry(entry);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Load mimetype error: {}", (Object)e.getMessage(), (Object)e);
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    this.initialized = true;
                }
            }
        }
    }

    private void parseMimeEntry(String entry) {
        Pattern typePattern;
        Matcher typeMatcher;
        if ((entry = entry.trim()).isEmpty() || entry.charAt(0) == '#') {
            return;
        }
        int equalIdx = (entry = entry.replaceAll("\\s*#.*", "")).indexOf(61);
        if (equalIdx > 0 && (typeMatcher = (typePattern = Pattern.compile("\\b(\"\\p{Graph}+?/\\p{Graph}+?\"|\\p{Graph}+/\\p{Graph}+\\b)")).matcher(entry)).find()) {
            String type = typeMatcher.group();
            if (type.charAt(0) == '\"') {
                type = type.substring(1, type.length() - 1);
            }
            String EXTEQUAL = "extensions=";
            String extRegex = "\\bextensions=(\"[\\p{Graph}\\p{Blank}]+?\"|\\p{Graph}+\\b)";
            Pattern extPattern = Pattern.compile(extRegex);
            Matcher extMatcher = extPattern.matcher(entry);
            if (extMatcher.find()) {
                String[] extList;
                String exts = extMatcher.group().substring("extensions=".length());
                if (exts.charAt(0) == '\"') {
                    exts = exts.substring(1, exts.length() - 1);
                }
                String DESCRIPTIONEQUAL = "description=";
                String descriptionRegex = "\\bdescription=([\\s\\S]*;)";
                Pattern descriptionPattern = Pattern.compile(descriptionRegex);
                Matcher descriptionMatcher = descriptionPattern.matcher(entry);
                String description = descriptionMatcher.find() ? descriptionMatcher.group() : null;
                for (String ext : extList = exts.split("[\\p{Blank}\\p{Punct}]+")) {
                    this.putIfAbsent(ext, type, description);
                }
            }
        }
    }
}

